/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.translator.internal;

import de.be4.classicalb.core.parser.node.AAnticipatedEventstatus;
import de.be4.classicalb.core.parser.node.AConvergentEventstatus;
import de.be4.classicalb.core.parser.node.ADescriptionEvent;
import de.be4.classicalb.core.parser.node.ADescriptionExpression;
import de.be4.classicalb.core.parser.node.ADescriptionPragma;
import de.be4.classicalb.core.parser.node.ADescriptionPredicate;
import de.be4.classicalb.core.parser.node.AEvent;
import de.be4.classicalb.core.parser.node.AEventBModelParseUnit;
import de.be4.classicalb.core.parser.node.AEventsModelClause;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AInvariantModelClause;
import de.be4.classicalb.core.parser.node.AOrdinaryEventstatus;
import de.be4.classicalb.core.parser.node.ARefinesModelClause;
import de.be4.classicalb.core.parser.node.ASeesModelClause;
import de.be4.classicalb.core.parser.node.ATheoremsModelClause;
import de.be4.classicalb.core.parser.node.AVariablesModelClause;
import de.be4.classicalb.core.parser.node.AVariantModelClause;
import de.be4.classicalb.core.parser.node.AWitness;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PDescriptionPragma;
import de.be4.classicalb.core.parser.node.PEvent;
import de.be4.classicalb.core.parser.node.PEventstatus;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.PSubstitution;
import de.be4.classicalb.core.parser.node.PWitness;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.node.TPragmaFreeText;
import de.prob.core.translator.TranslationFailedException;
import de.prob.eventb.translator.AbstractComponentTranslator;
import de.prob.eventb.translator.internal.EProofStatus;
import de.prob.eventb.translator.internal.ProofObligation;
import de.prob.eventb.translator.internal.SequentSource;
import de.prob.eventb.translator.internal.TranslationVisitor;
import de.prob.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eventb.core.EventBAttributes;
import org.eventb.core.IConvergenceElement;
import org.eventb.core.IEvent;
import org.eventb.core.IEventBRoot;
import org.eventb.core.IGuard;
import org.eventb.core.IInvariant;
import org.eventb.core.ILabeledElement;
import org.eventb.core.IMachineRoot;
import org.eventb.core.IPOSequent;
import org.eventb.core.IPOSource;
import org.eventb.core.IPSRoot;
import org.eventb.core.IPSStatus;
import org.eventb.core.ISCAction;
import org.eventb.core.ISCEvent;
import org.eventb.core.ISCExpressionElement;
import org.eventb.core.ISCGuard;
import org.eventb.core.ISCIdentifierElement;
import org.eventb.core.ISCInternalContext;
import org.eventb.core.ISCInvariant;
import org.eventb.core.ISCMachineRoot;
import org.eventb.core.ISCParameter;
import org.eventb.core.ISCPredicateElement;
import org.eventb.core.ISCRefinesEvent;
import org.eventb.core.ISCRefinesMachine;
import org.eventb.core.ISCVariable;
import org.eventb.core.ISCVariant;
import org.eventb.core.ISCWitness;
import org.eventb.core.ITraceableElement;
import org.eventb.core.IVariable;
import org.eventb.core.IVariant;
import org.eventb.core.IWitness;
import org.eventb.core.ast.Assignment;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.ITypeEnvironment;
import org.eventb.core.ast.ITypeEnvironmentBuilder;
import org.eventb.core.basis.Event;
import org.eventb.core.basis.Guard;
import org.rodinp.core.IAttributeType;
import org.rodinp.core.IElementType;
import org.rodinp.core.IRodinElement;
import org.rodinp.core.RodinDBException;

public class ModelTranslator
extends AbstractComponentTranslator {
    private final ISCMachineRoot machine;
    private final AEventBModelParseUnit model = new AEventBModelParseUnit();
    private final FormulaFactory ff;
    private final ITypeEnvironment te;
    private final IMachineRoot origin;
    private String refines;
    private boolean broken = false;

    public static ModelTranslator create(ISCMachineRoot model) throws TranslationFailedException {
        ModelTranslator modelTranslator = new ModelTranslator(model);
        try {
            modelTranslator.translate();
        }
        catch (CoreException re) {
            String message = "Rodin Database Exception / Core Exception: \n" + re.getLocalizedMessage();
            throw new TranslationFailedException(modelTranslator.getClass().toString(), message);
        }
        catch (RuntimeException e) {
            String message = "Possible cause: building aborted or still in progress. Please wait until building has finished before starting ProB. If this does not help, perform a clean and start ProB after building has finished.\nException was: " + e.getClass().getSimpleName() + "\n" + e.getLocalizedMessage();
            throw new TranslationFailedException(modelTranslator.getClass().toString(), message);
        }
        return modelTranslator;
    }

    public AEventBModelParseUnit getModelAST() {
        if (this.broken) {
            Logger.notifyUser("The machine contains Rodin Problems. ProB will continue, but you may observe unexpected behaviour");
            return this.model;
        }
        return this.model;
    }

    public String getRefinementDependency() {
        return this.refines;
    }

    private ModelTranslator(ISCMachineRoot machine) throws TranslationFailedException {
        super(machine.getComponentName());
        this.machine = machine;
        this.origin = machine.getMachineRoot();
        this.ff = machine.getFormulaFactory();
        try {
            this.te = machine.getTypeEnvironment();
        }
        catch (CoreException e) {
            throw new TranslationFailedException(machine.getComponentName(), "A Rodin exception occured during translation process. Original Exception: " + e.getLocalizedMessage());
        }
    }

    private void translate() throws CoreException, TranslationFailedException {
        Logger.assertProB("machine.getRodinFile().isConsistent() [Note: Maybe you can fix this Rodin problem by refreshing and rebuilding the project]", this.machine.getRodinFile().isConsistent());
        this.broken = !this.machine.isAccurate();
        this.translateMachine();
        this.collectProofInfo();
        this.collectPragmas();
    }

    private void collectPragmas() throws RodinDBException {
        this.addUnitPragmas((ISCIdentifierElement[])this.machine.getSCVariables());
    }

    private void collectProofInfo() {
        LinkedList<String> bugs = new LinkedList<String>();
        try {
            IPSStatus[] statuses;
            IPSRoot proofStatus = this.machine.getPSRoot();
            IPSStatus[] iPSStatusArray = statuses = proofStatus.getStatuses();
            int n = statuses.length;
            int n2 = 0;
            while (n2 < n) {
                IPSStatus status = iPSStatusArray[n2];
                int confidence = status.getConfidence();
                boolean broken = status.isBroken();
                EProofStatus pstatus = EProofStatus.UNPROVEN;
                if (!broken && confidence > 0 && confidence <= 500) {
                    pstatus = EProofStatus.REVIEWED;
                }
                if (!broken && confidence == 1000) {
                    pstatus = EProofStatus.PROVEN;
                }
                IPOSequent sequent = status.getPOSequent();
                IPOSource[] sources = sequent.getSources();
                String name = sequent.getDescription();
                ArrayList<SequentSource> s = new ArrayList<SequentSource>(sources.length);
                IPOSource[] iPOSourceArray = sources;
                int n3 = sources.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPOSource source = iPOSourceArray[n4];
                    IRodinElement srcElement = source.getSource();
                    if (!srcElement.exists() || !(srcElement instanceof ILabeledElement) && !(srcElement instanceof IVariant)) {
                        bugs.add(status.getElementName());
                        break;
                    }
                    if (srcElement instanceof ILabeledElement) {
                        ILabeledElement le = (ILabeledElement)srcElement;
                        IElementType type = srcElement.getElementType();
                        s.add(new SequentSource((IElementType<? extends IRodinElement>)type, le.getLabel()));
                    } else if (srcElement instanceof IVariant) {
                        IElementType type = srcElement.getElementType();
                        s.add(new SequentSource((IElementType<? extends IRodinElement>)type, this.machine.getComponentName()));
                    }
                    if (srcElement instanceof Guard) {
                        Event srcEvent = (Event)srcElement.getParent();
                        String srvEventName = srcEvent.getLabel();
                        s.add(new SequentSource((IElementType<? extends IRodinElement>)srcEvent.getElementType(), srvEventName));
                    }
                    ++n4;
                }
                this.addProof(new ProofObligation((IEventBRoot)this.origin, s, name, pstatus));
                ++n2;
            }
        }
        catch (Exception e) {
            bugs.add(e.getLocalizedMessage());
        }
        if (!bugs.isEmpty()) {
            String message = "Translation incomplete due to a Bug in Rodin. This does not affect correctness of the Animation/Model Checking but can decrease its performance. Skipped discharged information about: " + String.join((CharSequence)",", bugs);
            Logger.notifyUser(message);
        }
    }

    private void translateMachine() throws CoreException, TranslationFailedException {
        this.model.setName(new TIdentifierLiteral(this.machine.getRodinFile().getBareName()));
        ArrayList<Object> clauses = new ArrayList<Object>();
        clauses.add(this.processContexts());
        ARefinesModelClause ref = this.processRefines();
        if (ref != null) {
            clauses.add(ref);
        }
        clauses.add(this.processVariables());
        clauses.add(this.processInvariants());
        clauses.add(this.processTheorems());
        AVariantModelClause var = this.processVariant();
        if (var != null) {
            clauses.add(var);
        }
        clauses.add(this.processEvents());
        this.model.setModelClauses(clauses);
    }

    private AVariantModelClause processVariant() throws CoreException, TranslationFailedException {
        AVariantModelClause var;
        ISCVariant[] variant = this.machine.getSCVariants();
        if (variant.length == 1) {
            PExpression expression = this.translateExpression(this.ff, this.te, (ISCExpressionElement)variant[0]);
            var = new AVariantModelClause(expression);
        } else if (variant.length == 0) {
            var = null;
        } else {
            throw new TranslationFailedException(this.machine.getComponentName(), "expected at most one variant, but there were " + variant.length);
        }
        return var;
    }

    private ARefinesModelClause processRefines() throws CoreException, TranslationFailedException {
        ARefinesModelClause ref;
        ISCRefinesMachine[] refinesClauses = this.machine.getSCRefinesClauses();
        if (refinesClauses.length == 1) {
            String name = refinesClauses[0].getAbstractSCMachine().getBareName();
            ref = new ARefinesModelClause(new TIdentifierLiteral(name));
            this.refines = name;
        } else if (refinesClauses.length == 0) {
            ref = null;
            this.refines = null;
        } else {
            throw new TranslationFailedException(this.machine.getComponentName(), "expected at most one refined machine, but there were " + refinesClauses.length);
        }
        return ref;
    }

    private ASeesModelClause processContexts() throws RodinDBException {
        ISCInternalContext[] seenContexts = this.machine.getSCSeenContexts();
        ArrayList<TIdentifierLiteral> contexts = new ArrayList<TIdentifierLiteral>(seenContexts.length);
        ISCInternalContext[] iSCInternalContextArray = seenContexts;
        int n = seenContexts.length;
        int n2 = 0;
        while (n2 < n) {
            ISCInternalContext context = iSCInternalContextArray[n2];
            String componentName = context.getComponentName();
            contexts.add(new TIdentifierLiteral(componentName));
            ++n2;
        }
        return new ASeesModelClause(contexts);
    }

    private AEventsModelClause processEvents() throws TranslationFailedException, CoreException {
        AEventsModelClause clause = new AEventsModelClause();
        ISCEvent[] events = this.machine.getSCEvents();
        ArrayList<Object> eventsList = new ArrayList<Object>(events.length);
        ISCEvent[] iSCEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            ISCVariable[] variables;
            ISCEvent revent = iSCEventArray[n2];
            this.broken = this.broken || !revent.isAccurate();
            ITypeEnvironmentBuilder localEnv = revent.getTypeEnvironment(this.te);
            localEnv.addAll(this.te);
            ISCVariable[] iSCVariableArray = variables = this.machine.getSCVariables();
            int n3 = variables.length;
            int n4 = 0;
            while (n4 < n3) {
                ISCVariable variable = iSCVariableArray[n4];
                if (variable.isAbstract() || variable.isConcrete()) {
                    localEnv.add(variable.getIdentifier(this.ff).withPrime());
                }
                ++n4;
            }
            AEvent event = new AEvent();
            event.setEventName(new TIdentifierLiteral(revent.getLabel()));
            this.labelMapping.put(event, revent);
            ArrayList<PPredicate> guards = new ArrayList<PPredicate>();
            ArrayList<PPredicate> theorems = new ArrayList<PPredicate>();
            event.setStatus(this.extractEventStatus(revent));
            event.setRefines(this.extractRefinedEvents(revent));
            event.setVariables(this.extractParameters(revent));
            this.extractGuards(revent, (ITypeEnvironment)localEnv, guards, theorems);
            event.setGuards(guards);
            event.setTheorems(theorems);
            event.setWitness(this.extractWitnesses(revent, (ITypeEnvironment)localEnv));
            event.setAssignments(this.extractActions(revent, (ITypeEnvironment)localEnv));
            IEvent ucevent = (IEvent)revent.getSource();
            if (ucevent.hasAttribute((IAttributeType)EventBAttributes.COMMENT_ATTRIBUTE)) {
                String commentString = ucevent.getAttributeValue(EventBAttributes.COMMENT_ATTRIBUTE);
                TPragmaFreeText desc = new TPragmaFreeText(commentString);
                ADescriptionPragma descPragma = new ADescriptionPragma(Collections.singletonList(desc));
                eventsList.add(new ADescriptionEvent((PDescriptionPragma)descPragma, (PEvent)event));
            } else {
                eventsList.add(event);
            }
            ++n2;
        }
        clause.setEvent(eventsList);
        return clause;
    }

    private PEventstatus extractEventStatus(ISCEvent revent) throws TranslationFailedException, CoreException {
        AOrdinaryEventstatus status;
        IConvergenceElement.Convergence convergence = revent.getConvergence();
        switch (convergence) {
            case ORDINARY: {
                status = new AOrdinaryEventstatus();
                break;
            }
            case ANTICIPATED: {
                status = new AAnticipatedEventstatus();
                break;
            }
            case CONVERGENT: {
                status = new AConvergentEventstatus();
                break;
            }
            default: {
                throw new TranslationFailedException(this.machine.getComponentName(), "unexpected convergent status " + String.valueOf(convergence));
            }
        }
        return status;
    }

    private List<TIdentifierLiteral> extractRefinedEvents(ISCEvent revent) throws CoreException {
        ISCRefinesEvent[] refinesClauses = revent.getSCRefinesClauses();
        ArrayList<TIdentifierLiteral> refines = new ArrayList<TIdentifierLiteral>(refinesClauses.length);
        ISCRefinesEvent[] iSCRefinesEventArray = refinesClauses;
        int n = refinesClauses.length;
        int n2 = 0;
        while (n2 < n) {
            ISCRefinesEvent refinesEvent = iSCRefinesEventArray[n2];
            String label = refinesEvent.getAbstractSCEvent().getLabel();
            refines.add(new TIdentifierLiteral(label));
            ++n2;
        }
        return refines;
    }

    private List<PExpression> extractParameters(ISCEvent revent) throws RodinDBException {
        ISCParameter[] parameters = revent.getSCParameters();
        ArrayList<PExpression> parametersList = new ArrayList<PExpression>(parameters.length);
        ISCParameter[] iSCParameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ISCParameter parameter = iSCParameterArray[n2];
            AIdentifierExpression id = new AIdentifierExpression(Arrays.asList(new TIdentifierLiteral(parameter.getIdentifierString())));
            parametersList.add((PExpression)id);
            this.labelMapping.put(id, parameter);
            ++n2;
        }
        return parametersList;
    }

    private void extractGuards(ISCEvent revent, ITypeEnvironment localEnv, List<PPredicate> guardsList, List<PPredicate> theoremsList) throws CoreException {
        ISCGuard[] guards;
        ISCGuard[] iSCGuardArray = guards = revent.getSCGuards();
        int n = guards.length;
        int n2 = 0;
        while (n2 < n) {
            ISCGuard guard = iSCGuardArray[n2];
            PPredicate predicate = this.translatePredicate(this.ff, localEnv, (ISCPredicateElement)guard);
            IGuard ucg = (IGuard)guard.getSource();
            ADescriptionPredicate descpredicate = null;
            if (ucg.hasAttribute((IAttributeType)EventBAttributes.COMMENT_ATTRIBUTE)) {
                String commentString = ucg.getAttributeValue(EventBAttributes.COMMENT_ATTRIBUTE);
                TPragmaFreeText desc = new TPragmaFreeText(commentString);
                ADescriptionPragma descPragma = new ADescriptionPragma(Collections.singletonList(desc));
                descpredicate = new ADescriptionPredicate((PDescriptionPragma)descPragma, predicate);
            }
            if (guard.isTheorem()) {
                if (descpredicate == null) {
                    theoremsList.add(predicate);
                } else {
                    theoremsList.add((PPredicate)descpredicate);
                }
            } else if (descpredicate == null) {
                guardsList.add(predicate);
            } else {
                guardsList.add((PPredicate)descpredicate);
            }
            this.labelMapping.put(predicate, guard);
            ++n2;
        }
    }

    private AVariablesModelClause processVariables() throws RodinDBException {
        ISCVariable[] variables = this.machine.getSCVariables();
        AVariablesModelClause variablesModelClause = new AVariablesModelClause();
        ArrayList<Object> list = new ArrayList<Object>(variables.length);
        ISCVariable[] iSCVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            ISCVariable variable = iSCVariableArray[n2];
            if (variable.isConcrete()) {
                TIdentifierLiteral literal = new TIdentifierLiteral(variable.getIdentifierString());
                AIdentifierExpression id = new AIdentifierExpression(Arrays.asList(literal));
                IVariable ucv = (IVariable)variable.getSource();
                if (ucv.hasAttribute((IAttributeType)EventBAttributes.COMMENT_ATTRIBUTE)) {
                    String commentString = ucv.getAttributeValue(EventBAttributes.COMMENT_ATTRIBUTE);
                    TPragmaFreeText desc = new TPragmaFreeText(commentString);
                    ADescriptionPragma descPragma = new ADescriptionPragma(Collections.singletonList(desc));
                    ADescriptionExpression descid = new ADescriptionExpression((PDescriptionPragma)descPragma, (PExpression)id);
                    list.add(descid);
                } else {
                    list.add(id);
                }
            }
            ++n2;
        }
        variablesModelClause.setIdentifiers(list);
        return variablesModelClause;
    }

    private List<PWitness> extractWitnesses(ISCEvent revent, ITypeEnvironment localEnv) throws CoreException {
        ISCWitness[] witnesses = revent.getSCWitnesses();
        ArrayList<PWitness> witnessList = new ArrayList<PWitness>(witnesses.length);
        ISCWitness[] iSCWitnessArray = witnesses;
        int n = witnesses.length;
        int n2 = 0;
        while (n2 < n) {
            ISCWitness witness = iSCWitnessArray[n2];
            PPredicate predicate = this.translatePredicate(this.ff, localEnv, (ISCPredicateElement)witness);
            TIdentifierLiteral label = new TIdentifierLiteral(witness.getLabel());
            IWitness ucw = (IWitness)witness.getSource();
            if (ucw.hasAttribute((IAttributeType)EventBAttributes.COMMENT_ATTRIBUTE)) {
                String commentString = ucw.getAttributeValue(EventBAttributes.COMMENT_ATTRIBUTE);
                TPragmaFreeText desc = new TPragmaFreeText(commentString);
                ADescriptionPragma descPragma = new ADescriptionPragma(Collections.singletonList(desc));
                ADescriptionPredicate dpred = new ADescriptionPredicate((PDescriptionPragma)descPragma, predicate);
                witnessList.add((PWitness)new AWitness(label, (PPredicate)dpred));
                this.labelMapping.put(dpred, witness);
            } else {
                witnessList.add((PWitness)new AWitness(label, predicate));
                this.labelMapping.put(predicate, witness);
            }
            ++n2;
        }
        return witnessList;
    }

    private List<PSubstitution> extractActions(ISCEvent revent, ITypeEnvironment localEnv) throws CoreException {
        ISCAction[] actions = revent.getSCActions();
        ArrayList<PSubstitution> actionList = new ArrayList<PSubstitution>();
        ISCAction[] iSCActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            ISCAction action = iSCActionArray[n2];
            Assignment assignment = action.getAssignment(localEnv);
            PSubstitution substitution = TranslationVisitor.translateAssignment(assignment);
            actionList.add(substitution);
            this.labelMapping.put(substitution, action);
            ++n2;
        }
        return actionList;
    }

    private AInvariantModelClause processInvariants() throws CoreException, TranslationFailedException {
        AInvariantModelClause invariantModelClause = new AInvariantModelClause();
        invariantModelClause.setPredicates(this.getPredicateList(this.machine.getSCInvariants(), false));
        return invariantModelClause;
    }

    private ATheoremsModelClause processTheorems() throws CoreException, TranslationFailedException {
        ATheoremsModelClause theoremsModelClause = new ATheoremsModelClause();
        theoremsModelClause.setPredicates(this.getPredicateList(this.machine.getSCInvariants(), true));
        return theoremsModelClause;
    }

    private List<PPredicate> getPredicateList(ISCInvariant[] predicates, boolean theorems) throws CoreException, TranslationFailedException {
        ArrayList<PPredicate> list = new ArrayList<PPredicate>(predicates.length);
        ISCInvariant[] iSCInvariantArray = predicates;
        int n = predicates.length;
        int n2 = 0;
        while (n2 < n) {
            ISCInvariant evPredicate = iSCInvariantArray[n2];
            if (evPredicate.isTheorem() == theorems && this.isDefinedHere((ITraceableElement)evPredicate)) {
                PPredicate predicate = this.translatePredicate(this.ff, this.te, (ISCPredicateElement)evPredicate);
                if (evPredicate.getSource() instanceof IInvariant) {
                    IInvariant ucp = (IInvariant)evPredicate.getSource();
                    if (ucp.hasAttribute((IAttributeType)EventBAttributes.COMMENT_ATTRIBUTE)) {
                        String commentString = ucp.getAttributeValue(EventBAttributes.COMMENT_ATTRIBUTE);
                        TPragmaFreeText desc = new TPragmaFreeText(commentString);
                        ADescriptionPragma descPragma = new ADescriptionPragma(Collections.singletonList(desc));
                        ADescriptionPredicate dpred = new ADescriptionPredicate((PDescriptionPragma)descPragma, predicate);
                        list.add((PPredicate)dpred);
                        this.labelMapping.put(dpred, evPredicate);
                    } else {
                        list.add(predicate);
                        this.labelMapping.put(predicate, evPredicate);
                    }
                } else {
                    list.add(predicate);
                    this.labelMapping.put(predicate, evPredicate);
                }
            }
            ++n2;
        }
        return list;
    }

    private boolean isDefinedHere(ITraceableElement element) throws CoreException, TranslationFailedException {
        boolean result;
        IRodinElement parentsource = element.getSource().getParent();
        String currentName = this.machine.getComponentName();
        if (parentsource instanceof IMachineRoot) {
            IMachineRoot src = (IMachineRoot)parentsource;
            String srcName = src.getRodinFile().getBareName();
            result = currentName.equals(srcName);
        } else {
            Logger.notifyUser("Source of invariant in " + currentName + " is not a machine. Invariant may be added multiple times.");
            result = false;
        }
        return result;
    }

    @Override
    public Node getAST() {
        return this.getModelAST();
    }
}

