/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.translator;

import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.Switch;
import de.prob.core.translator.TranslationFailedException;
import de.prob.eventb.translator.internal.TranslationVisitor;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.output.StructuredPrologOutput;
import de.prob.prolog.term.PrologTerm;
import de.prob.tmparser.OperatorMapping;
import de.prob.tmparser.TheoryMappingException;
import de.prob.tmparser.TheoryMappingParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eventb.core.EventBAttributes;
import org.eventb.core.IEventBProject;
import org.eventb.core.ISCIdentifierElement;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IParseResult;
import org.eventb.core.ast.ITypeEnvironment;
import org.eventb.core.ast.ITypeEnvironmentBuilder;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.Type;
import org.eventb.theory.core.IAvailableTheory;
import org.eventb.theory.core.IAvailableTheoryProject;
import org.eventb.theory.core.IDeployedTheoryRoot;
import org.eventb.theory.core.ISCAxiomaticDefinitionAxiom;
import org.eventb.theory.core.ISCAxiomaticDefinitionsBlock;
import org.eventb.theory.core.ISCAxiomaticOperatorDefinition;
import org.eventb.theory.core.ISCConstructorArgument;
import org.eventb.theory.core.ISCDatatypeConstructor;
import org.eventb.theory.core.ISCDatatypeDefinition;
import org.eventb.theory.core.ISCDirectOperatorDefinition;
import org.eventb.theory.core.ISCNewOperatorDefinition;
import org.eventb.theory.core.ISCOperatorArgument;
import org.eventb.theory.core.ISCRecursiveDefinitionCase;
import org.eventb.theory.core.ISCRecursiveOperatorDefinition;
import org.eventb.theory.core.ISCTheoryRoot;
import org.eventb.theory.core.ISCTypeArgument;
import org.eventb.theory.core.ITheoryPathRoot;
import org.eventb.theory.core.IUseTheory;
import org.eventb.theory.core.TheoryAttributes;
import org.eventb.theory.core.TheoryElement;
import org.rodinp.core.IRodinProject;
import org.rodinp.core.RodinDBException;

public class Theories {
    private static final String PROB_THEORY_MAPPING_SUFFIX = "ptm";

    public static void translate(IEventBProject project, IPrologTermOutput pout) throws TranslationFailedException {
        try {
            ITheoryPathRoot[] theoryPaths;
            HashSet<String> visitedTheories = new HashSet<String>();
            IRodinProject rProject = project.getRodinProject();
            ITheoryPathRoot[] iTheoryPathRootArray = theoryPaths = (ITheoryPathRoot[])rProject.getRootElementsOfType(ITheoryPathRoot.ELEMENT_TYPE);
            int n = theoryPaths.length;
            int n2 = 0;
            while (n2 < n) {
                ITheoryPathRoot theoryPath = iTheoryPathRootArray[n2];
                IAvailableTheoryProject[] iAvailableTheoryProjectArray = theoryPath.getAvailableTheoryProjects();
                int n3 = iAvailableTheoryProjectArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAvailableTheoryProject ap = iAvailableTheoryProjectArray[n4];
                    IAvailableTheory[] iAvailableTheoryArray = ap.getTheories();
                    int n5 = iAvailableTheoryArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IAvailableTheory at = iAvailableTheoryArray[n6];
                        IDeployedTheoryRoot deployedTheory = at.getDeployedTheory();
                        Theories.savePrintTranslation(deployedTheory, visitedTheories, pout);
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new TranslationFailedException((Exception)((Object)e));
        }
    }

    private static Iterable<IDeployedTheoryRoot> getUsedTheories(IDeployedTheoryRoot deployedTheory) throws RodinDBException {
        ArrayList<IDeployedTheoryRoot> theories = new ArrayList<IDeployedTheoryRoot>();
        IUseTheory[] iUseTheoryArray = deployedTheory.getUsedTheories();
        int n = iUseTheoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUseTheory use = iUseTheoryArray[n2];
            if (use.hasUseTheory()) {
                theories.add(use.getUsedTheory());
            }
            ++n2;
        }
        return theories;
    }

    private static void savePrintTranslation(IDeployedTheoryRoot theory, Collection<String> visitedTheories, IPrologTermOutput opto) throws CoreException, TranslationFailedException {
        StructuredPrologOutput pto = new StructuredPrologOutput();
        Theories.printTranslation(theory, visitedTheories, pto);
        for (PrologTerm result : pto.getSentences()) {
            opto.printTerm(result);
        }
    }

    private static void printTranslation(IDeployedTheoryRoot theory, Collection<String> visitedTheories, StructuredPrologOutput pto) throws CoreException, TranslationFailedException {
        String name = theory.getElementName();
        if (!visitedTheories.contains(name)) {
            visitedTheories.add(name);
            Iterable<IDeployedTheoryRoot> imported = Theories.getUsedTheories(theory);
            Theories.printImportedTheories(imported, visitedTheories, pto);
            Theories.printTheory(theory, imported, pto);
            pto.fullstop();
        }
    }

    private static void printImportedTheories(Iterable<IDeployedTheoryRoot> theories, Collection<String> visitedTheories, StructuredPrologOutput pto) throws CoreException, TranslationFailedException {
        for (IDeployedTheoryRoot theory : theories) {
            Theories.printTranslation(theory, visitedTheories, pto);
        }
    }

    private static void printTheory(IDeployedTheoryRoot theory, Iterable<IDeployedTheoryRoot> imported, StructuredPrologOutput pto) throws CoreException, TranslationFailedException {
        pto.openTerm("theory");
        Theories.printTheoryName(theory, (IPrologTermOutput)pto);
        Theories.printListOfImportedTheories(imported, pto);
        Theories.printIdentifiers((ISCIdentifierElement[])theory.getSCTypeParameters(), (IPrologTermOutput)pto);
        Theories.printDataTypes((ISCTheoryRoot)theory, (IPrologTermOutput)pto);
        Theories.printOperatorDefs((ISCTheoryRoot)theory, (IPrologTermOutput)pto);
        Theories.printAxiomaticDefs((ISCTheoryRoot)theory, (IPrologTermOutput)pto);
        Theories.findProBMappingFile((ISCTheoryRoot)theory, (IPrologTermOutput)pto);
        pto.closeTerm();
    }

    private static void printListOfImportedTheories(Iterable<IDeployedTheoryRoot> imported, StructuredPrologOutput pto) throws RodinDBException {
        pto.openList();
        for (IDeployedTheoryRoot theory : imported) {
            Theories.printTheoryName(theory, (IPrologTermOutput)pto);
        }
        pto.closeList();
    }

    private static void printTheoryName(IDeployedTheoryRoot theory, IPrologTermOutput pto) {
        pto.openTerm("theory_name");
        pto.printAtom(theory.getRodinProject().getElementName());
        pto.printAtom(theory.getElementName());
        pto.closeTerm();
    }

    private static void findProBMappingFile(ISCTheoryRoot theory, IPrologTermOutput pto) throws TranslationFailedException {
        Collection<OperatorMapping> mappings;
        String theoryName = theory.getComponentName();
        Path path = new Path(theoryName + ".ptm");
        IProject project = theory.getRodinProject().getProject();
        if (project.exists((IPath)path)) {
            IFile file = project.getFile((IPath)path);
            mappings = Theories.readMappingFile(file, theory);
        } else {
            mappings = Collections.emptyList();
        }
        Theories.printMappings(mappings, pto);
    }

    private static Collection<OperatorMapping> readMappingFile(IFile file, ISCTheoryRoot theory) throws TranslationFailedException {
        try {
            InputStream input = file.getContents();
            String name = theory.getComponentName();
            InputStreamReader reader = new InputStreamReader(input);
            return TheoryMappingParser.parseTheoryMapping((String)name, (Reader)reader);
        }
        catch (CoreException e) {
            throw new TranslationFailedException((Exception)((Object)e));
        }
        catch (TheoryMappingException e) {
            throw new TranslationFailedException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new TranslationFailedException(e);
        }
    }

    private static void printMappings(Collection<OperatorMapping> mappings, IPrologTermOutput pto) {
        pto.openList();
        for (OperatorMapping mapping : mappings) {
            mapping.printProlog(pto);
        }
        pto.closeList();
    }

    private static void printIdentifiers(ISCIdentifierElement[] identifiers, IPrologTermOutput pto) throws RodinDBException {
        pto.openList();
        ISCIdentifierElement[] iSCIdentifierElementArray = identifiers;
        int n = identifiers.length;
        int n2 = 0;
        while (n2 < n) {
            ISCIdentifierElement identifier = iSCIdentifierElementArray[n2];
            pto.printAtom(identifier.getIdentifierString());
            ++n2;
        }
        pto.closeList();
    }

    private static void printDataTypes(ISCTheoryRoot theory, IPrologTermOutput pto) throws CoreException {
        FormulaFactory ff = theory.getFormulaFactory();
        pto.openList();
        ISCDatatypeDefinition[] iSCDatatypeDefinitionArray = theory.getSCDatatypeDefinitions();
        int n = iSCDatatypeDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISCDatatypeDefinition def = iSCDatatypeDefinitionArray[n2];
            Theories.printDataType(def, ff, pto);
            ++n2;
        }
        pto.closeList();
    }

    private static void printDataType(ISCDatatypeDefinition def, FormulaFactory ff, IPrologTermOutput pto) throws CoreException {
        pto.openTerm("datatype");
        pto.printAtom(def.getIdentifierString());
        pto.openList();
        ISCTypeArgument[] iSCTypeArgumentArray = def.getTypeArguments();
        int n = iSCTypeArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISCTypeArgument arg = iSCTypeArgumentArray[n2];
            Theories.printType(arg.getSCGivenType(ff), pto);
            ++n2;
        }
        pto.closeList();
        pto.openList();
        iSCTypeArgumentArray = def.getConstructors();
        n = iSCTypeArgumentArray.length;
        n2 = 0;
        while (n2 < n) {
            ISCTypeArgument cons = iSCTypeArgumentArray[n2];
            Theories.printConstructor((ISCDatatypeConstructor)cons, def, ff, pto);
            ++n2;
        }
        pto.closeList();
        pto.closeTerm();
    }

    private static void printConstructor(ISCDatatypeConstructor cons, ISCDatatypeDefinition def, FormulaFactory ff, IPrologTermOutput pto) throws CoreException {
        pto.openTerm("constructor");
        pto.printAtom(cons.getIdentifierString());
        pto.openList();
        ISCConstructorArgument[] iSCConstructorArgumentArray = cons.getConstructorArguments();
        int n = iSCConstructorArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISCConstructorArgument arg = iSCConstructorArgumentArray[n2];
            Theories.printTypedIdentifierForRecursiveDataTypeDef("destructor", (ISCIdentifierElement)arg, def, ff, pto);
            ++n2;
        }
        pto.closeList();
        pto.closeTerm();
    }

    private static void printOperatorDefs(ISCTheoryRoot theory, IPrologTermOutput pto) throws CoreException {
        pto.openList();
        ISCNewOperatorDefinition[] iSCNewOperatorDefinitionArray = theory.getSCNewOperatorDefinitions();
        int n = iSCNewOperatorDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISCNewOperatorDefinition opdef = iSCNewOperatorDefinitionArray[n2];
            Theories.printOperator(opdef, theory, pto);
            ++n2;
        }
        pto.closeList();
    }

    private static void printOperator(ISCNewOperatorDefinition opDef, ISCTheoryRoot theory, IPrologTermOutput prologOutput) throws CoreException {
        ISCRecursiveOperatorDefinition[] definitions;
        prologOutput.openTerm("operator");
        prologOutput.printAtom(opDef.getLabel());
        FormulaFactory ff = theory.getFormulaFactory();
        ITypeEnvironment teFromFF = theory.getTypeEnvironment(ff);
        ITypeEnvironmentBuilder te = ff.makeTypeEnvironment();
        te.addAll(teFromFF);
        Theories.printOperatorArguments(opDef.getOperatorArguments(), prologOutput, ff);
        ISCOperatorArgument[] iSCOperatorArgumentArray = opDef.getOperatorArguments();
        int n = iSCOperatorArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISCOperatorArgument arg = iSCOperatorArgumentArray[n2];
            te.add(arg.getIdentifier(ff));
            ++n2;
        }
        Predicate wdCondition = opDef.getWDCondition(ff, (ITypeEnvironment)te);
        Theories.printPredicate(prologOutput, wdCondition);
        prologOutput.openList();
        Theories.processDefinitions(ff, (ITypeEnvironment)te, prologOutput, opDef.getDirectOperatorDefinitions());
        prologOutput.closeList();
        prologOutput.openList();
        ISCRecursiveOperatorDefinition[] iSCRecursiveOperatorDefinitionArray = definitions = opDef.getRecursiveOperatorDefinitions();
        int n3 = definitions.length;
        int n4 = 0;
        while (n4 < n3) {
            ISCRecursiveDefinitionCase[] recursiveDefinitionCases;
            ISCRecursiveOperatorDefinition definition = iSCRecursiveOperatorDefinitionArray[n4];
            String indArg = definition.getInductiveArgument();
            ISCRecursiveDefinitionCase[] iSCRecursiveDefinitionCaseArray = recursiveDefinitionCases = definition.getRecursiveDefinitionCases();
            int n5 = recursiveDefinitionCases.length;
            int n6 = 0;
            while (n6 < n5) {
                ISCRecursiveDefinitionCase c = iSCRecursiveDefinitionCaseArray[n6];
                Theories.printRecDefCase(indArg, prologOutput, ff, c);
                ++n6;
            }
            ++n4;
        }
        prologOutput.closeList();
        prologOutput.closeTerm();
    }

    private static void printRecDefCase(String indArg, IPrologTermOutput prologOutput, FormulaFactory ff, ISCRecursiveDefinitionCase c) throws RodinDBException {
        String es = c.getExpressionString();
        IParseResult pr = ff.parseExpression(es, null);
        Expression ex = pr.getParsedExpression();
        String formulaAsString = c.getAttributeValue(TheoryAttributes.FORMULA_ATTRIBUTE);
        Formula formula = TheoryElement.parseFormula((String)formulaAsString, (FormulaFactory)ff, (boolean)false);
        prologOutput.openTerm("case");
        prologOutput.printAtom(indArg);
        prologOutput.openList();
        if (ex == null) {
            throw new IllegalStateException("Empty expression for axiomatic recursive definition case " + es + " and inductive argument " + indArg);
        }
        FreeIdentifier[] freeIdentifierArray = ex.getFreeIdentifiers();
        int n = freeIdentifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            FreeIdentifier fi = freeIdentifierArray[n2];
            prologOutput.printAtom(fi.getName());
            ++n2;
        }
        prologOutput.closeList();
        Theories.printExpression(prologOutput, ex);
        if (formula instanceof Predicate) {
            Theories.printPredicate(prologOutput, (Predicate)formula);
        } else if (formula instanceof Expression) {
            Theories.printExpression(prologOutput, (Expression)formula);
        } else {
            throw new IllegalStateException("unexpected formula of type " + formula.getClass().getName() + " for recursive definition case in theory");
        }
        prologOutput.closeTerm();
    }

    private static void printOperatorArguments(ISCOperatorArgument[] arguments, IPrologTermOutput prologOutput, FormulaFactory ff) throws CoreException {
        prologOutput.openList();
        ISCOperatorArgument[] iSCOperatorArgumentArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            ISCOperatorArgument argument = iSCOperatorArgumentArray[n2];
            Theories.printTypedIdentifier("argument", (ISCIdentifierElement)argument, ff, prologOutput);
            ++n2;
        }
        prologOutput.closeList();
    }

    private static void processDefinitions(FormulaFactory ff, ITypeEnvironment te, IPrologTermOutput prologOutput, ISCDirectOperatorDefinition[] directOperatorDefinitions) throws CoreException {
        ISCDirectOperatorDefinition[] iSCDirectOperatorDefinitionArray = directOperatorDefinitions;
        int n = directOperatorDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            Predicate pp;
            ISCDirectOperatorDefinition def = iSCDirectOperatorDefinitionArray[n2];
            Formula scFormula = def.getSCFormula(ff, te);
            if (scFormula instanceof Predicate) {
                pp = (Predicate)scFormula;
                Theories.printPredicate(prologOutput, pp);
            }
            if (scFormula instanceof Expression) {
                pp = (Expression)scFormula;
                Theories.printExpression(prologOutput, (Expression)pp);
            }
            ++n2;
        }
    }

    private static void printTypedIdentifierForRecursiveDataTypeDef(String functor, ISCIdentifierElement id, ISCDatatypeDefinition def, FormulaFactory ff, IPrologTermOutput pto) throws CoreException {
        pto.openTerm(functor);
        pto.printAtom(id.getIdentifierString());
        String typeString = id.getAttributeValue(EventBAttributes.TYPE_ATTRIBUTE);
        if (def.getIdentifierString().equals(typeString)) {
            Theories.printTypeOfDataType(def, ff, pto);
        } else {
            Type type = id.getType(ff);
            Theories.printType(type, pto);
        }
        pto.closeTerm();
    }

    private static void printTypeOfDataType(ISCDatatypeDefinition def, FormulaFactory ff, IPrologTermOutput pto) throws CoreException {
        pto.openTerm("extended_expr");
        pto.printAtom("none");
        pto.printAtom(def.getIdentifierString());
        pto.openList();
        ISCTypeArgument[] iSCTypeArgumentArray = def.getTypeArguments();
        int n = iSCTypeArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISCTypeArgument arg = iSCTypeArgumentArray[n2];
            Theories.printType(arg.getSCGivenType(ff), pto);
            ++n2;
        }
        pto.closeList();
        pto.openList();
        pto.closeList();
        pto.closeTerm();
    }

    private static void printTypedIdentifier(String functor, ISCIdentifierElement id, FormulaFactory ff, IPrologTermOutput pto) throws CoreException {
        pto.openTerm(functor);
        pto.printAtom(id.getIdentifierString());
        Type type = id.getType(ff);
        Theories.printType(type, pto);
        pto.closeTerm();
    }

    private static void printType(Type type, IPrologTermOutput pto) {
        Theories.printExpression(pto, type.toExpression());
    }

    private static void printExpression(IPrologTermOutput prologOutput, Expression ee) {
        PExpression expr = TranslationVisitor.translateExpression(ee);
        ASTProlog pv = new ASTProlog(prologOutput, null);
        expr.apply((Switch)pv);
    }

    private static void printPredicate(IPrologTermOutput prologOutput, Predicate pp) {
        PPredicate predicate = TranslationVisitor.translatePredicate(pp);
        ASTProlog pv = new ASTProlog(prologOutput, null);
        predicate.apply((Switch)pv);
    }

    private static void printAxiomaticDefs(ISCTheoryRoot theory, IPrologTermOutput pto) throws CoreException {
        FormulaFactory ff = theory.getFormulaFactory();
        ITypeEnvironment te = theory.getTypeEnvironment(ff);
        pto.openList();
        ISCAxiomaticDefinitionsBlock[] iSCAxiomaticDefinitionsBlockArray = theory.getSCAxiomaticDefinitionsBlocks();
        int n = iSCAxiomaticDefinitionsBlockArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISCAxiomaticDefinitionsBlock block = iSCAxiomaticDefinitionsBlockArray[n2];
            Theories.printAxiomaticDefBlock(block, ff, te, pto);
            ++n2;
        }
        pto.closeList();
    }

    private static void printAxiomaticDefBlock(ISCAxiomaticDefinitionsBlock block, FormulaFactory ff, ITypeEnvironment te, IPrologTermOutput pto) throws CoreException {
        pto.openTerm("axiomatic_def_block");
        pto.printAtom(block.getLabel());
        Theories.printIdentifiers((ISCIdentifierElement[])block.getAxiomaticTypeDefinitions(), pto);
        Theories.printAxiomaticOperators(block.getAxiomaticOperatorDefinitions(), ff, pto);
        Theories.printAxioms(block.getAxiomaticDefinitionAxioms(), te, pto);
        pto.closeTerm();
    }

    private static void printAxiomaticOperators(ISCAxiomaticOperatorDefinition[] axdefs, FormulaFactory ff, IPrologTermOutput pto) throws CoreException {
        pto.openList();
        ISCAxiomaticOperatorDefinition[] iSCAxiomaticOperatorDefinitionArray = axdefs;
        int n = axdefs.length;
        int n2 = 0;
        while (n2 < n) {
            ISCAxiomaticOperatorDefinition opdef = iSCAxiomaticOperatorDefinitionArray[n2];
            pto.openTerm("opdef");
            pto.printAtom(opdef.getLabel());
            Theories.printOperatorArguments(opdef.getOperatorArguments(), pto, ff);
            pto.openList();
            pto.closeList();
            pto.closeTerm();
            ++n2;
        }
        pto.closeList();
    }

    private static void printAxioms(ISCAxiomaticDefinitionAxiom[] axioms, ITypeEnvironment te, IPrologTermOutput pto) throws CoreException {
        pto.openList();
        ISCAxiomaticDefinitionAxiom[] iSCAxiomaticDefinitionAxiomArray = axioms;
        int n = axioms.length;
        int n2 = 0;
        while (n2 < n) {
            ISCAxiomaticDefinitionAxiom axiom = iSCAxiomaticDefinitionAxiomArray[n2];
            Theories.printPredicate(pto, axiom.getPredicate(te));
            ++n2;
        }
        pto.closeList();
    }

    public static void touch() throws NoClassDefFoundError {
    }
}

