/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.translator;

import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.prob.core.translator.pragmas.IPragma;
import de.prob.core.translator.pragmas.UnitPragma;
import de.prob.eventb.translator.internal.ProofObligation;
import de.prob.eventb.translator.internal.TranslationVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eventb.core.ISCExpressionElement;
import org.eventb.core.ISCIdentifierElement;
import org.eventb.core.ISCPredicateElement;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.ITypeEnvironment;
import org.eventb.core.ast.Predicate;
import org.rodinp.core.IAttributeType;
import org.rodinp.core.IInternalElement;
import org.rodinp.core.RodinCore;
import org.rodinp.core.RodinDBException;

public abstract class AbstractComponentTranslator {
    protected final Map<Node, IInternalElement> labelMapping = new ConcurrentHashMap<Node, IInternalElement>();
    private final List<IPragma> pragmas = new ArrayList<IPragma>();
    private final List<ProofObligation> proofs = new ArrayList<ProofObligation>();
    private final String resourceName;

    public Map<Node, IInternalElement> getLabelMapping() {
        return Collections.unmodifiableMap(this.labelMapping);
    }

    protected AbstractComponentTranslator(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResource() {
        return this.resourceName;
    }

    public List<IPragma> getPragmas() {
        return Collections.unmodifiableList(this.pragmas);
    }

    public List<ProofObligation> getProofs() {
        return Collections.unmodifiableList(this.proofs);
    }

    protected void addProof(ProofObligation po) {
        this.proofs.add(po);
    }

    protected void addUnitPragmas(ISCIdentifierElement[] elements) throws RodinDBException {
        try {
            IAttributeType.String UNITATTRIBUTE = RodinCore.getStringAttrType((String)"de.prob.units.unitPragmaAttribute");
            ISCIdentifierElement[] iSCIdentifierElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String content;
                ISCIdentifierElement variable = iSCIdentifierElementArray[n2];
                if (variable.hasAttribute((IAttributeType)UNITATTRIBUTE) && !(content = variable.getAttributeValue(UNITATTRIBUTE)).isEmpty()) {
                    this.pragmas.add(new UnitPragma(this.getResource(), variable.getIdentifierString(), content));
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected PPredicate translatePredicate(FormulaFactory ff, ITypeEnvironment env, ISCPredicateElement predicate) throws CoreException {
        Predicate pred = predicate.getPredicate(env);
        return TranslationVisitor.translatePredicate(pred);
    }

    protected PExpression translateExpression(FormulaFactory ff, ITypeEnvironment env, ISCExpressionElement expression) throws CoreException {
        Expression expr = expression.getExpression(env);
        return TranslationVisitor.translateExpression(expr);
    }

    public abstract Node getAST();
}

