/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.types;

import de.prob.core.types.ProbDataType;

public abstract class SetLikeProbType
extends ProbDataType {
    private final String variant;
    private final ProbDataType innerType;

    protected SetLikeProbType(String variant, ProbDataType innerType) {
        if (innerType == null) {
            throw new IllegalArgumentException("Inner type to " + variant + " constructor must not be null");
        }
        this.variant = variant;
        this.innerType = innerType;
    }

    @Override
    public int getOperatorPriority() {
        return 500;
    }

    @Override
    public void prettyprint(StringBuilder builder) {
        builder.append(this.variant);
        builder.append('(');
        this.innerType.prettyprint(builder);
        builder.append(')');
    }

    public ProbDataType getInnerType() {
        return this.innerType;
    }

    public boolean equals(Object other) {
        boolean isEqual;
        if (other == this) {
            isEqual = true;
        } else if (other != null && other instanceof SetLikeProbType) {
            SetLikeProbType setlikeother = (SetLikeProbType)other;
            isEqual = this.variant == setlikeother.variant && this.innerType.equals(setlikeother.innerType);
        } else {
            isEqual = false;
        }
        return isEqual;
    }

    public int hashCode() {
        return this.innerType.hashCode() * 17 + this.variant.hashCode();
    }
}

