/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.ltl;

import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExampleBinaryOperator;
import de.prob.core.domainobjects.ltl.CounterExampleNegation;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleSince;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;
import java.util.ArrayList;
import java.util.List;

public final class CounterExampleTrigger
extends CounterExampleBinaryOperator {
    public CounterExampleTrigger(CounterExample counterExample, CounterExampleProposition firstArgument, CounterExampleProposition secondArgument) {
        super("T", "Trigger", counterExample, firstArgument, secondArgument);
        this.checkBySince(counterExample, firstArgument, secondArgument);
    }

    private void checkBySince(CounterExample counterExample, CounterExampleProposition firstArgument, CounterExampleProposition secondArgument) {
        CounterExampleNegation notFirst = new CounterExampleNegation(counterExample, firstArgument);
        CounterExampleNegation notSecond = new CounterExampleNegation(counterExample, secondArgument);
        CounterExampleSince since = new CounterExampleSince(counterExample, notFirst, notSecond);
        this.addCheck(new CounterExampleNegation(counterExample, since));
    }

    @Override
    protected CounterExampleValueType calculate(int position) {
        return this.calculateTriggerOperator(position);
    }

    private CounterExampleValueType calculateTriggerOperator(int position) {
        int unknownStateIndex;
        CounterExampleValueType result = CounterExampleValueType.UNKNOWN;
        List<CounterExampleValueType> firstCheckedValues = new ArrayList<CounterExampleValueType>(this.getFirstArgument().getValues().subList(0, position + 1));
        List<CounterExampleValueType> secondCheckedValues = new ArrayList<CounterExampleValueType>(this.getSecondArgument().getValues().subList(0, position + 1));
        int secondIndex = -1;
        boolean trueOrUnknown = false;
        int firstIndex = firstCheckedValues.lastIndexOf((Object)CounterExampleValueType.TRUE);
        if (firstIndex != -1) {
            secondIndex = secondCheckedValues.subList(firstIndex, secondCheckedValues.size()).lastIndexOf((Object)CounterExampleValueType.FALSE);
            if (secondIndex == -1) {
                trueOrUnknown = true;
                unknownStateIndex = this.indexOfUnknownState(firstCheckedValues.subList(firstIndex, firstCheckedValues.size()), secondCheckedValues.subList(firstIndex, secondCheckedValues.size()), true);
                if (unknownStateIndex != -1) {
                    firstCheckedValues = firstCheckedValues.subList(unknownStateIndex += firstIndex, firstCheckedValues.size());
                    secondCheckedValues = secondCheckedValues.subList(unknownStateIndex, secondCheckedValues.size());
                    firstIndex = -1;
                } else if (!(secondCheckedValues = secondCheckedValues.subList(firstIndex, secondCheckedValues.size())).contains((Object)CounterExampleValueType.UNKNOWN)) {
                    result = CounterExampleValueType.TRUE;
                } else {
                    firstCheckedValues = firstCheckedValues.subList(firstIndex, firstCheckedValues.size());
                    firstIndex = -1;
                }
            }
        } else if (!(firstCheckedValues.contains((Object)CounterExampleValueType.UNKNOWN) || secondCheckedValues.contains((Object)CounterExampleValueType.FALSE) || secondCheckedValues.contains((Object)CounterExampleValueType.UNKNOWN))) {
            trueOrUnknown = true;
            result = CounterExampleValueType.TRUE;
            firstCheckedValues.clear();
        }
        if (!trueOrUnknown) {
            secondIndex = secondCheckedValues.lastIndexOf((Object)CounterExampleValueType.FALSE);
            if (secondIndex != -1) {
                firstCheckedValues = firstCheckedValues.subList(secondIndex + 1, firstCheckedValues.size());
                firstIndex = -1;
                if (!firstCheckedValues.contains((Object)CounterExampleValueType.UNKNOWN)) {
                    result = CounterExampleValueType.FALSE;
                } else {
                    unknownStateIndex = this.indexOfUnknownState(firstCheckedValues, secondCheckedValues.subList(secondIndex + 1, secondCheckedValues.size()), true);
                    if (unknownStateIndex != -1) {
                        secondCheckedValues = secondCheckedValues.subList(secondIndex + 1, secondCheckedValues.size());
                        firstCheckedValues = firstCheckedValues.subList(unknownStateIndex, firstCheckedValues.size());
                        secondCheckedValues = secondCheckedValues.subList(unknownStateIndex, secondCheckedValues.size());
                    } else {
                        secondCheckedValues = secondCheckedValues.subList(secondIndex, secondCheckedValues.size());
                    }
                    secondIndex = -1;
                }
            } else {
                unknownStateIndex = this.indexOfUnknownState(firstCheckedValues, secondCheckedValues, true);
                if (unknownStateIndex != -1) {
                    firstCheckedValues = firstCheckedValues.subList(unknownStateIndex, firstCheckedValues.size());
                    secondCheckedValues = secondCheckedValues.subList(unknownStateIndex, secondCheckedValues.size());
                }
            }
        }
        this.fillHighlightedPositions(position, firstIndex, secondIndex, firstCheckedValues.size(), secondCheckedValues.size(), true);
        return result;
    }
}

