/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.ltl;

import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;
import de.prob.logging.Logger;
import java.util.ArrayList;
import java.util.List;

public abstract class CounterExampleBinaryOperator
extends CounterExampleProposition {
    protected final CounterExampleProposition firstArgument;
    protected final CounterExampleProposition secondArgument;
    protected List<List<Integer>> firstHighlightedPositions = new ArrayList<List<Integer>>();
    protected List<List<Integer>> secondHighlightedPositions = new ArrayList<List<Integer>>();

    public CounterExampleBinaryOperator(String name, String fullName, CounterExample counterExample, CounterExampleProposition firstArgument, CounterExampleProposition secondArgument) {
        super(name, fullName, counterExample);
        this.firstArgument = firstArgument;
        this.secondArgument = secondArgument;
    }

    protected abstract CounterExampleValueType calculate(int var1);

    @Override
    protected List<CounterExampleValueType> calculate() {
        List<CounterExampleValueType> first = this.firstArgument.getValues();
        List<CounterExampleValueType> second = this.secondArgument.getValues();
        int size = first.size();
        Logger.assertProB("Sizes of traces do not match", size == second.size());
        ArrayList<CounterExampleValueType> values = new ArrayList<CounterExampleValueType>();
        int i = 0;
        while (i < size) {
            values.add(this.calculate(i));
            ++i;
        }
        return values;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public List<CounterExampleProposition> getChildren() {
        List<CounterExampleProposition> children = super.getChildren();
        children.addAll(this.firstArgument.getChildren());
        children.addAll(this.secondArgument.getChildren());
        return children;
    }

    public CounterExampleProposition getFirstArgument() {
        return this.firstArgument;
    }

    public CounterExampleProposition getSecondArgument() {
        return this.secondArgument;
    }

    public List<List<Integer>> getFirstHighlightedPositions() {
        return this.firstHighlightedPositions;
    }

    public List<List<Integer>> getSecondHighlightedPositions() {
        return this.secondHighlightedPositions;
    }

    public String toString() {
        return "(" + String.valueOf(this.firstArgument) + ")" + (" " + this.name + " ") + ("(" + String.valueOf(this.secondArgument) + ")");
    }

    protected void fillHighlightedPositions(int position, int firstIndex, int secondIndex, int firstCheckedSize, int secondCheckedSize, boolean isPast) {
        this.firstHighlightedPositions.add(this.fillPositions(position, firstIndex, firstCheckedSize, isPast));
        this.secondHighlightedPositions.add(this.fillPositions(position, secondIndex, secondCheckedSize, isPast));
    }

    protected int indexOfUnknownState(List<CounterExampleValueType> firstCheckedValues, List<CounterExampleValueType> secondCheckedValues, boolean past) {
        int unknownStateIndex = -1;
        if (past) {
            int i = firstCheckedValues.size() - 1;
            while (i >= 0) {
                if (firstCheckedValues.get(i).equals((Object)CounterExampleValueType.UNKNOWN) && secondCheckedValues.get(i).equals((Object)CounterExampleValueType.UNKNOWN)) {
                    unknownStateIndex = i;
                    break;
                }
                --i;
            }
        } else {
            int i = 0;
            while (i < firstCheckedValues.size()) {
                if (firstCheckedValues.get(i).equals((Object)CounterExampleValueType.UNKNOWN) && secondCheckedValues.get(i).equals((Object)CounterExampleValueType.UNKNOWN)) {
                    unknownStateIndex = i;
                    break;
                }
                ++i;
            }
        }
        return unknownStateIndex;
    }
}

