/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects;

import de.prob.core.command.CommandException;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ResultParserException;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.unicode.UnicodeTranslator;
import java.util.Objects;

public final class Variable {
    private final String identifier;
    private final String value;
    private final PrologTerm rawValue;

    public Variable(CompoundPrologTerm binding) throws CommandException {
        CompoundPrologTerm variableName;
        try {
            variableName = BindingGenerator.getCompoundTerm((PrologTerm)binding.getArgument(1), (int)0);
        }
        catch (ResultParserException e) {
            CommandException commandException = new CommandException(e.getLocalizedMessage(), e);
            commandException.notifyUserOnce();
            throw commandException;
        }
        this.identifier = variableName.getFunctor();
        PrologTerm raw = binding.getArgument(2);
        if (raw.hasFunctor("?", 0)) {
            this.rawValue = null;
            this.value = null;
        } else {
            CompoundPrologTerm term;
            this.rawValue = raw;
            try {
                term = BindingGenerator.getCompoundTerm((PrologTerm)binding.getArgument(3), (int)0);
            }
            catch (ResultParserException e) {
                CommandException commandException = new CommandException(e.getLocalizedMessage(), e);
                commandException.notifyUserOnce();
                throw commandException;
            }
            this.value = UnicodeTranslator.toUnicode((String)term.getFunctor());
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getValue() {
        return this.value;
    }

    @Deprecated
    public PrologTerm getRawValue() {
        return this.rawValue;
    }

    public boolean hasValue() {
        return this.rawValue != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.identifier);
        sb.append(": ").append(this.value);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        boolean equal;
        if (obj == this) {
            equal = true;
        } else if (obj != null && obj instanceof Variable) {
            Variable other = (Variable)obj;
            equal = this.identifier.equals(other.identifier) && Objects.equals(this.value, other.value);
        } else {
            equal = false;
        }
        return equal;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

