/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OperationInfo {
    private final String name;
    private final List<String> parameters;

    public OperationInfo(String name, List<String> parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public static List<String> extractNames(Collection<OperationInfo> names) {
        ArrayList<String> result = new ArrayList<String>();
        for (OperationInfo operationInfo : names) {
            result.add(operationInfo.getName());
        }
        return result;
    }

    public static OperationInfo getParams(String name, Collection<OperationInfo> names) {
        for (OperationInfo info : names) {
            if (!name.equals(info.getName())) continue;
            return info;
        }
        return null;
    }
}

