/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.ComposedCommand;
import de.prob.core.command.ExploreStateCommand;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.History;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.Collection;

public class SetTraceCommand
implements IComposableCommand {
    private final Collection<Operation> operations;
    private final ExploreStateCommand[] exploreStateCmds;
    private final ComposedCommand compExplore;
    private boolean hasBeenProcessed = false;

    public SetTraceCommand(Collection<Operation> operations) {
        this.operations = new ArrayList<Operation>(operations);
        this.exploreStateCmds = SetTraceCommand.toExplore(operations);
        this.compExplore = new ComposedCommand(this.exploreStateCmds);
    }

    private static ExploreStateCommand[] toExplore(Collection<Operation> operations) {
        int size = operations.size();
        ExploreStateCommand[] states = new ExploreStateCommand[size + 1];
        if (operations.isEmpty()) {
            states[0] = new ExploreStateCommand("root");
        } else {
            String initial = operations.iterator().next().getSource();
            states[0] = new ExploreStateCommand(initial);
            int i = 1;
            for (Operation op : operations) {
                String dest = op.getDestination();
                states[i] = new ExploreStateCommand(dest);
                ++i;
            }
        }
        return states;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) throws CommandException {
        this.compExplore.writeCommand(pto);
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        this.compExplore.processResult(bindings);
        this.hasBeenProcessed = true;
    }

    public void setTraceInHistory(Animator animator, Integer currentPosition) {
        if (!this.hasBeenProcessed) {
            throw new IllegalStateException("command must be sent to ProB before calling setTraceInHistory.");
        }
        History history = animator.getHistory();
        history.reset();
        Operation curOp = null;
        State curState = null;
        State rootState = this.exploreStateCmds[0].getState();
        history.add(rootState, null);
        if (currentPosition != null && currentPosition == 0) {
            curState = rootState;
        }
        int pos = 1;
        for (Operation operation : this.operations) {
            State state = this.exploreStateCmds[pos].getState();
            history.add(state, operation);
            if (currentPosition != null && pos == currentPosition) {
                curOp = operation;
                curState = state;
            }
            ++pos;
        }
        if (curState != null) {
            animator.announceCurrentStateChanged(curState, curOp);
        }
    }
}

