/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.ComposedCommand;
import de.prob.core.command.IComposableCommand;
import de.prob.core.command.SetPreferenceCommand;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.Platform;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class SetPreferencesCommand
implements IComposableCommand {
    private static final String PROB_ANIMATION_PREFERENCES = "prob_animation_preferences";
    private static final Collection<String> INVALID_PROPERTIES = Collections.unmodifiableCollection(new HashSet<String>(Arrays.asList("title", "project", "machine")));
    private final Preferences preferences;
    private final IComposableCommand cmds;

    public static Preferences getPreferences() {
        return Platform.getPreferencesService().getRootNode().node("instance").node(PROB_ANIMATION_PREFERENCES);
    }

    public SetPreferencesCommand() {
        this(SetPreferencesCommand.getPreferences());
    }

    public SetPreferencesCommand(Preferences customConfiguration) {
        String[] names;
        this.preferences = customConfiguration;
        try {
            names = this.preferences.keys();
        }
        catch (BackingStoreException e) {
            names = new String[]{};
            Logger.notifyUser("Error while storing ProB Preferences", e);
        }
        ArrayList<SetPreferenceCommand> commands = new ArrayList<SetPreferenceCommand>(names.length);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String k = stringArray[n2];
            if (this.validCommand(k)) {
                String value = this.preferences.get(k, null);
                commands.add(new SetPreferenceCommand(k, value));
            }
            ++n2;
        }
        this.cmds = new ComposedCommand(commands.toArray(IComposableCommand.EMPTY_ARRAY));
    }

    public static void setPreferences(Animator a) throws ProBException {
        SetPreferencesCommand c = SetPreferencesCommand.createSetPreferencesCommand(a);
        a.execute(c);
    }

    public static SetPreferencesCommand createSetPreferencesCommand(Animator a) {
        SetPreferencesCommand c = a.getCustomConfiguration() != null ? new SetPreferencesCommand(a.getCustomConfiguration()) : new SetPreferencesCommand();
        return c;
    }

    private boolean validCommand(String key) {
        return !INVALID_PROPERTIES.contains(key);
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        this.cmds.processResult(bindings);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) throws CommandException {
        this.cmds.writeCommand(pto);
    }
}

