/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ModelCheckingSearchOption {
    breadth_first_search(0, "Breadth First Search", false),
    find_deadlocks(1, "Find Deadlocks", true),
    find_invariant_violations(2, "Find Invariant Violations", true),
    find_assertion_violations(3, "Find Theorem Violations", false),
    inspect_existing_nodes(4, "Recheck Existing States", false),
    stop_at_full_coverage(5, "Stop when all Events are Covered", false);

    private final String text;
    private final int pos;
    private boolean enabledByDefault;
    private static final Map<Integer, ModelCheckingSearchOption> lookup;

    static {
        lookup = new HashMap<Integer, ModelCheckingSearchOption>();
        for (ModelCheckingSearchOption s : EnumSet.allOf(ModelCheckingSearchOption.class)) {
            lookup.put(s.getPos(), s);
        }
    }

    private ModelCheckingSearchOption(int pos, String text, boolean enabledByDefault) {
        this.pos = pos;
        this.text = text;
        this.enabledByDefault = enabledByDefault;
    }

    public final String getDescription() {
        return this.text;
    }

    public final int getPos() {
        return this.pos;
    }

    public final boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public final void setEnabledByDefault(boolean val) {
        this.enabledByDefault = val;
    }

    public static final ModelCheckingSearchOption get(int code) {
        return lookup.get(code);
    }
}

