/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.MachineDescription;
import de.prob.core.prolog.TypedIdentifierGenerator;
import de.prob.core.types.TypedIdentifier;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;

public class GetMachineObjectsCommand
implements IComposableCommand {
    private MachineObjectsResult machineObjectsResult;

    public static MachineObjectsResult getMachineObjects(Animator a) throws ProBException {
        GetMachineObjectsCommand getMachineObjectsCommand = new GetMachineObjectsCommand();
        a.execute(getMachineObjectsCommand);
        return getMachineObjectsCommand.getResult();
    }

    private static MachineDescription.Section[] getSections(ISimplifiedROMap<String, PrologTerm> binding, String var) throws CommandException {
        PrologTerm term = GetMachineObjectsCommand.getNotNullTerm(binding, var);
        if (term.isList()) {
            ListPrologTerm list = (ListPrologTerm)term;
            MachineDescription.Section[] result = new MachineDescription.Section[list.size()];
            int i = 0;
            while (i < list.size()) {
                MachineDescription.SectionType sectionType;
                PrologTerm elem = list.get(i);
                if (elem.hasFunctor("model", 1)) {
                    sectionType = MachineDescription.SectionType.MODEL;
                } else if (elem.hasFunctor("context", 1)) {
                    sectionType = MachineDescription.SectionType.CONTEXT;
                } else {
                    CommandException cmdException = new CommandException("Prolog section list contains non-atomic component");
                    cmdException.notifyUserOnce();
                    throw cmdException;
                }
                PrologTerm arg1 = ((CompoundPrologTerm)elem).getArgument(1);
                String name = PrologTerm.atomicString((PrologTerm)arg1);
                result[i] = new MachineDescription.Section(sectionType, name);
                ++i;
            }
            return result;
        }
        CommandException cmdException = new CommandException("Expected section list, but received a term that is not a list");
        cmdException.notifyUserOnce();
        throw cmdException;
    }

    private static TypedIdentifier[] createTypedIdentifiers(ISimplifiedROMap<String, PrologTerm> binding, String var) throws CommandException {
        PrologTerm term = GetMachineObjectsCommand.getNotNullTerm(binding, var);
        if (!term.isList()) {
            CommandException cmdException = new CommandException("Expected list in Prolog variable " + var + ", but was: " + term.toString());
            cmdException.notifyUserOnce();
            throw cmdException;
        }
        TypedIdentifier[] result = TypedIdentifierGenerator.extract((ListPrologTerm)term);
        return result;
    }

    private static PrologTerm getNotNullTerm(ISimplifiedROMap<String, PrologTerm> binding, String var) throws CommandException {
        PrologTerm term = (PrologTerm)binding.get((Object)var);
        if (term == null) {
            CommandException cmdException = new CommandException("Prolog variable " + var + " has no associated value");
            cmdException.notifyUserOnce();
            throw cmdException;
        }
        return term;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        MachineDescription.Section[] sections = GetMachineObjectsCommand.getSections(bindings, "Sections");
        TypedIdentifier[] setElements = GetMachineObjectsCommand.createTypedIdentifiers(bindings, "SetElements");
        TypedIdentifier[] constants = GetMachineObjectsCommand.createTypedIdentifiers(bindings, "Constants");
        TypedIdentifier[] variables = GetMachineObjectsCommand.createTypedIdentifiers(bindings, "Variables");
        TypedIdentifier[] operations = GetMachineObjectsCommand.createTypedIdentifiers(bindings, "Operations");
        this.machineObjectsResult = new MachineObjectsResult(sections, setElements, constants, variables, operations);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("get_machine_objects").printVariable("Sections").printVariable("SetElements").printVariable("Constants").printVariable("Variables").printVariable("Operations").closeTerm();
    }

    public MachineObjectsResult getResult() {
        return this.machineObjectsResult;
    }

    public static class MachineObjectsResult {
        public final MachineDescription.Section[] sections;
        public final TypedIdentifier[] setElements;
        public final TypedIdentifier[] constants;
        public final TypedIdentifier[] variables;
        public final TypedIdentifier[] operations;

        public MachineObjectsResult(MachineDescription.Section[] sections, TypedIdentifier[] setElements, TypedIdentifier[] constants, TypedIdentifier[] variables, TypedIdentifier[] operations) {
            this.sections = sections;
            this.setElements = setElements;
            this.constants = constants;
            this.variables = variables;
            this.operations = operations;
        }
    }
}

