/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.List;

public final class GetEnabledOperationsCommand
implements IComposableCommand {
    private static final String OPERATIONS_VARIABLE = "PLOps";
    private final String id;
    private List<Operation> enabledOperations;

    public GetEnabledOperationsCommand(String id) {
        this.id = id;
    }

    public static List<Operation> getOperations(Animator animator, String id) throws ProBException {
        GetEnabledOperationsCommand command = new GetEnabledOperationsCommand(id);
        animator.execute(command);
        return command.getEnabledOperations();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        this.enabledOperations = new ArrayList<Operation>();
        ListPrologTerm prologTerm = (ListPrologTerm)bindings.get((Object)OPERATIONS_VARIABLE);
        for (PrologTerm op : prologTerm) {
            CompoundPrologTerm cpt = (CompoundPrologTerm)op;
            this.enabledOperations.add(Operation.fromPrologTerm((PrologTerm)cpt));
        }
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("computeOperationsForState");
        pto.printAtomOrNumber(this.id);
        pto.printVariable(OPERATIONS_VARIABLE);
        pto.closeTerm();
    }

    public List<Operation> getEnabledOperations() {
        return this.enabledOperations;
    }
}

