/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;

public class ConstraintBasedRefinementCheckCommand
implements IComposableCommand {
    private static final String COMMAND_NAME = "refinement_check";
    private static final String RESULT_VARIABLE = "R";
    private static final String RESULT_STRINGS_VARIABLE = "S";
    private ResultType result;
    private String resultsString = "";

    public ResultType getResult() {
        return this.result;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(COMMAND_NAME);
        pto.printVariable(RESULT_STRINGS_VARIABLE);
        pto.printVariable(RESULT_VARIABLE);
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        ResultType result;
        PrologTerm resultTerm = (PrologTerm)bindings.get((Object)RESULT_VARIABLE);
        ListPrologTerm resultStringTerm = (ListPrologTerm)bindings.get((Object)RESULT_STRINGS_VARIABLE);
        for (PrologTerm t : resultStringTerm) {
            this.resultsString = String.valueOf(this.resultsString) + PrologTerm.atomicString((PrologTerm)t) + "\n";
        }
        if (resultTerm.hasFunctor("time_out", 0)) {
            result = ResultType.INTERRUPTED;
        } else if (resultTerm.hasFunctor("true", 0)) {
            result = ResultType.VIOLATION_FOUND;
        } else if (resultTerm.hasFunctor("false", 0)) {
            result = ResultType.NO_VIOLATION_FOUND;
        } else {
            throw new CommandException("unexpected result from refinement check: " + String.valueOf(resultTerm));
        }
        this.result = result;
    }

    public String getResultsString() {
        return this.resultsString;
    }

    public static class RefinementCheckCounterExample {
        private final String eventName;
        private final Operation step1;
        private final Operation step2;

        public RefinementCheckCounterExample(String eventName, Operation step1, Operation step2) {
            this.eventName = eventName;
            this.step1 = step1;
            this.step2 = step2;
        }

        public String getEventName() {
            return this.eventName;
        }

        public Operation getStep1() {
            return this.step1;
        }

        public Operation getStep2() {
            return this.step2;
        }
    }

    public static enum ResultType {
        VIOLATION_FOUND,
        NO_VIOLATION_FOUND,
        INTERRUPTED;

    }
}

