/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.PrologTerm;

public class ConstraintBasedDeadlockCheckCommand
implements IComposableCommand {
    private static final String COMMAND_NAME = "deadlock_freedom_check";
    private static final String RESULT_VARIABLE = "R";
    private final PrologTerm predicate;
    private ResultType result;
    private String deadlockStateId;
    private Operation deadlockOperation;

    public ConstraintBasedDeadlockCheckCommand(PrologTerm predicate) {
        this.predicate = predicate;
    }

    public PrologTerm getPredicate() {
        return this.predicate;
    }

    public ResultType getResult() {
        return this.result;
    }

    public String getDeadlockStateId() {
        return this.deadlockStateId;
    }

    public Operation getDeadlockOperation() {
        return this.deadlockOperation;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(COMMAND_NAME);
        if (this.predicate != null) {
            this.predicate.toTermOutput(pto);
        }
        pto.printVariable(RESULT_VARIABLE);
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        ResultType result;
        PrologTerm resultTerm = (PrologTerm)bindings.get((Object)RESULT_VARIABLE);
        if (resultTerm.hasFunctor("no_deadlock_found", 0)) {
            result = ResultType.NO_DEADLOCK;
        } else if (resultTerm.hasFunctor("errors", 1)) {
            result = ResultType.ERROR;
        } else if (resultTerm.hasFunctor("interrupted", 0)) {
            result = ResultType.INTERRUPTED;
        } else if (resultTerm.hasFunctor("deadlock", 2)) {
            CompoundPrologTerm deadlockTerm = (CompoundPrologTerm)resultTerm;
            result = ResultType.DEADLOCK_FOUND;
            this.deadlockOperation = Operation.fromPrologTerm((PrologTerm)((CompoundPrologTerm)deadlockTerm.getArgument(1)));
            this.deadlockStateId = deadlockTerm.getArgument(2).toString();
        } else {
            throw new CommandException("unexpected result from deadlock check: " + String.valueOf(resultTerm));
        }
        this.result = result;
    }

    public static enum ResultType {
        DEADLOCK_FOUND,
        NO_DEADLOCK,
        ERROR,
        INTERRUPTED;

    }
}

