/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.PrologTerm;

public class ConstraintBasedAssertionCheckCommand
implements IComposableCommand {
    private static final String COMMAND_NAME = "cbc_static_assertion_violation_checking";
    private static final String RESULT_VARIABLE = "R";
    private ResultType result;
    private Operation counterExampleOperation;
    private String counterExampleStateID;

    public ResultType getResult() {
        return this.result;
    }

    public Operation getCounterExampleOperation() {
        return this.counterExampleOperation;
    }

    public String getCounterExampleStateID() {
        return this.counterExampleStateID;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(COMMAND_NAME);
        pto.printVariable(RESULT_VARIABLE);
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        ResultType result;
        PrologTerm resultTerm = (PrologTerm)bindings.get((Object)RESULT_VARIABLE);
        if (resultTerm.hasFunctor("interrupted", 0)) {
            result = ResultType.INTERRUPTED;
        } else if (resultTerm.hasFunctor("no_counterexample_found", 0)) {
            result = ResultType.NO_COUNTER_EXAMPLE_FOUND;
        } else if (resultTerm.hasFunctor("no_counterexample_exists", 0)) {
            result = ResultType.NO_COUNTER_EXAMPLE_EXISTS;
        } else if (resultTerm.hasFunctor("counterexample_found", 2)) {
            result = ResultType.COUNTER_EXAMPLE;
            CompoundPrologTerm counterExampleTerm = (CompoundPrologTerm)resultTerm;
            this.counterExampleOperation = Operation.fromPrologTerm(counterExampleTerm.getArgument(1));
            this.counterExampleStateID = counterExampleTerm.getArgument(2).toString();
        } else {
            throw new CommandException("unexpected result from static assertion check: " + String.valueOf(resultTerm));
        }
        this.result = result;
    }

    public static enum ResultType {
        INTERRUPTED,
        COUNTER_EXAMPLE,
        NO_COUNTER_EXAMPLE_FOUND,
        NO_COUNTER_EXAMPLE_EXISTS;

    }
}

