/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core;

import de.prob.core.LanguageDependendAnimationPart;
import de.prob.core.LimitedLogger;
import de.prob.core.StaticListenerRegistry;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.History;
import de.prob.core.domainobjects.MachineDescription;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.core.internal.Activator;
import de.prob.core.internal.AnimatorImpl;
import de.prob.core.internal.ServerConnection;
import de.prob.exceptions.ProBException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.prefs.Preferences;

public final class Animator {
    private static Animator animator = new Animator();
    private static Animator auxanimator = null;
    private volatile boolean dirty;
    private volatile boolean rodinProjectHasErrorsOrWarnings;
    private final Map<Object, Object> dataStore = new HashMap<Object, Object>();
    private AnimatorImpl implementation;
    private Preferences customConfiguration;

    public static final Animator getAnimator() {
        return animator;
    }

    public static final Animator getAuxAnimator() {
        if (auxanimator == null) {
            auxanimator = new Animator();
        }
        return auxanimator;
    }

    public static final void killAndReload() {
        Animator.killAndLoad(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void killAndLoad(File file) {
        Animator animator = Animator.animator;
        synchronized (animator) {
            Animator.animator.killImplementation();
            Animator.animator.createNewImplementation(file);
        }
    }

    private final synchronized void createNewImplementation(File file) {
        AnimatorImpl impl = new AnimatorImpl(new ServerConnection(), file);
        this.setImplementation(impl);
        StaticListenerRegistry.registerComputationListener(this.getHistory());
    }

    private synchronized void setImplementation(AnimatorImpl impl) {
        this.implementation = impl;
    }

    private final synchronized void killImplementation() {
        if (this.implementation != null) {
            History history = animator.getHistory();
            StaticListenerRegistry.unregisterComputationListener(history);
            this.implementation.shutdownImplementation();
            this.implementation = null;
        }
    }

    private Animator() {
    }

    private Animator(AnimatorImpl impl) {
        this.setImplementation(impl);
    }

    public final synchronized void shutdown() {
        if (this.implementation != null) {
            this.implementation.shutdownImplementation();
        }
    }

    public void announceReset() {
        this.getHistory().reset();
        Activator.reset();
    }

    public synchronized void announceCurrentStateChanged(State state, Operation operation) {
        Activator.currentStateChanged(state, operation);
    }

    public void announceComputedState(State state) {
        Activator.computedState(state);
    }

    public final synchronized void execute(IComposableCommand command) throws ProBException {
        LimitedLogger.getLogger().log("execute command", command, null);
        this.getImplementation().execute(command);
        LimitedLogger.getLogger().log("command executed", command, null);
    }

    public final synchronized State getCurrentState() {
        return this.getImplementation().getCurrentStateImpl();
    }

    public final synchronized History getHistory() {
        return this.getImplementation().getHistoryImpl();
    }

    public synchronized boolean isRunning() {
        return this.implementation != null;
    }

    private synchronized AnimatorImpl getImplementation() {
        if (this.implementation == null) {
            this.createNewImplementation(null);
        }
        return this.implementation;
    }

    public void setCustomConfiguration(Preferences customConfiguration) {
        if (customConfiguration != null) {
            this.customConfiguration = customConfiguration;
        }
    }

    public Preferences getCustomConfiguration() {
        return this.customConfiguration;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public void resetDirty() {
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setRodinProjectHasErrorsOrWarnings() {
        this.rodinProjectHasErrorsOrWarnings = true;
    }

    public void resetRodinProjectHasErrorsOrWarnings() {
        this.rodinProjectHasErrorsOrWarnings = false;
    }

    public boolean isRodinProjectHasErrorsOrWarnings() {
        return this.rodinProjectHasErrorsOrWarnings;
    }

    public void setMachineDescription(MachineDescription machineDescription) {
        this.getImplementation().setMachineDescription(machineDescription);
    }

    public MachineDescription getMachineDescription() {
        return this.getImplementation().getMachineDescription();
    }

    public boolean isMachineLoaded() {
        return this.getImplementation().isMachineLoaded();
    }

    public LanguageDependendAnimationPart getLanguageDependendPart() {
        return this.getImplementation().getLangdep();
    }

    public void setLanguageDependendPart(LanguageDependendAnimationPart ldPart) {
        this.getImplementation().setLangdep(ldPart);
    }

    public synchronized void setData(Object key, Object data) {
        this.dataStore.put(key, data);
    }

    public synchronized Object getData(Object key) {
        return this.dataStore.get(key);
    }

    public void sendUserInterruptSignal() {
        if (this.implementation != null) {
            this.implementation.sendUserInterruptSignal();
        }
    }
}

