/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.translator.internal;

import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.analysis.prolog.PositionPrinter;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.Switch;
import de.prob.core.translator.ITranslator;
import de.prob.core.translator.TranslationFailedException;
import de.prob.core.translator.pragmas.IPragma;
import de.prob.eventb.translator.AbstractComponentTranslator;
import de.prob.eventb.translator.Theories;
import de.prob.eventb.translator.internal.LabelPositionPrinter;
import de.prob.eventb.translator.internal.ProofObligation;
import de.prob.eventb.translator.internal.SequentSource;
import de.prob.prolog.output.IPrologTermOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eventb.core.IEventBProject;
import org.eventb.core.IEventBRoot;
import org.eventb.core.ISCInternalContext;
import org.eventb.core.ISCMachineRoot;
import org.rodinp.core.IInternalElement;
import org.rodinp.core.IRodinElement;
import org.rodinp.core.IRodinFile;
import org.rodinp.core.RodinDBException;

public abstract class EventBTranslator
implements ITranslator {
    protected final IEventBProject project;

    protected EventBTranslator(IEventBRoot root) {
        this.project = root.getEventBProject();
    }

    protected EventBTranslator(ISCInternalContext ctx) {
        Assert.isTrue((boolean)(ctx.getRoot() instanceof ISCMachineRoot));
        this.project = ((ISCMachineRoot)ctx.getRoot()).getEventBProject();
    }

    private LabelPositionPrinter createLabelPrositionPrinter(Collection<AbstractComponentTranslator> translators) throws TranslationFailedException {
        LabelPositionPrinter printer = new LabelPositionPrinter();
        for (AbstractComponentTranslator t : translators) {
            Map<Node, IInternalElement> labelMapping = t.getLabelMapping();
            printer.addNodes(labelMapping, t.getResource());
        }
        return printer;
    }

    private Collection<Node> translateModels(Collection<? extends AbstractComponentTranslator> refinementChainTranslators) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (AbstractComponentTranslator abstractComponentTranslator : refinementChainTranslators) {
            nodes.add(abstractComponentTranslator.getAST());
        }
        return nodes;
    }

    private void printModels(Collection<Node> nodes, IPrologTermOutput pout, ASTProlog prolog) {
        pout.openList();
        for (Node node : nodes) {
            node.apply((Switch)prolog);
        }
        pout.closeList();
    }

    private void printProofInformation(Collection<? extends AbstractComponentTranslator> refinementChainTranslators, Collection<? extends AbstractComponentTranslator> contextTranslators, IPrologTermOutput pout) throws TranslationFailedException {
        ArrayList<ProofObligation> list = new ArrayList<ProofObligation>();
        for (AbstractComponentTranslator abstractComponentTranslator : contextTranslators) {
            list.addAll(abstractComponentTranslator.getProofs());
        }
        for (AbstractComponentTranslator abstractComponentTranslator : refinementChainTranslators) {
            list.addAll(abstractComponentTranslator.getProofs());
        }
        for (ProofObligation proofObligation : list) {
            pout.openTerm("po");
            pout.printAtom(proofObligation.origin.getRodinFile().getBareName());
            pout.printAtom(proofObligation.kind);
            pout.openList();
            for (SequentSource source : proofObligation.sources) {
                pout.openTerm(source.type);
                pout.printAtom(source.label);
                pout.closeTerm();
            }
            pout.closeList();
            pout.printAtom(proofObligation.discharged.toString());
            pout.closeTerm();
        }
    }

    private void printPragmaContents(Collection<? extends AbstractComponentTranslator> refinementChainTranslators, Collection<? extends AbstractComponentTranslator> contextTranslators, IPrologTermOutput pout) {
        ArrayList<IPragma> pragmas = new ArrayList<IPragma>();
        for (AbstractComponentTranslator abstractComponentTranslator : contextTranslators) {
            pragmas.addAll(abstractComponentTranslator.getPragmas());
        }
        for (AbstractComponentTranslator abstractComponentTranslator : refinementChainTranslators) {
            pragmas.addAll(abstractComponentTranslator.getPragmas());
        }
        for (IPragma iPragma : pragmas) {
            iPragma.output(pout);
        }
    }

    private ASTProlog createAstVisitor(Collection<? extends AbstractComponentTranslator> refinementChainTranslators, Collection<? extends AbstractComponentTranslator> contextTranslators, IPrologTermOutput pout) throws TranslationFailedException {
        ArrayList<AbstractComponentTranslator> translators = new ArrayList<AbstractComponentTranslator>();
        translators.addAll(refinementChainTranslators);
        translators.addAll(contextTranslators);
        return new ASTProlog(pout, (PositionPrinter)this.createLabelPrositionPrinter(translators));
    }

    protected void printProlog(Collection<? extends AbstractComponentTranslator> refinementChainTranslators, Collection<? extends AbstractComponentTranslator> contextTranslators, IPrologTermOutput pout) throws TranslationFailedException {
        Collection<Node> machineNodes = this.translateModels(refinementChainTranslators);
        Collection<Node> contextNodes = this.translateModels(contextTranslators);
        boolean theoryIsUsed = this.areTheoriesAreUsed();
        if (theoryIsUsed) {
            this.checkIfTheoriesAvailable();
        }
        ASTProlog prolog = this.createAstVisitor(refinementChainTranslators, contextTranslators, pout);
        pout.openTerm("load_event_b_project");
        this.printModels(machineNodes, pout, prolog);
        this.printModels(contextNodes, pout, prolog);
        pout.openList();
        pout.openTerm("exporter_version");
        pout.printNumber(3L);
        pout.closeTerm();
        this.printProofInformation(refinementChainTranslators, contextTranslators, pout);
        if (theoryIsUsed) {
            this.translateTheories(this.project, pout);
        }
        this.printPragmaContents(refinementChainTranslators, contextTranslators, pout);
        pout.closeList();
        pout.printVariable("_Error");
        pout.closeTerm();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean areTheoriesAreUsed() throws TranslationFailedException {
        try {
            IRodinElement[] elements;
            IRodinElement[] iRodinElementArray = elements = this.project.getRodinProject().getChildren();
            int n = elements.length;
            int n2 = 0;
            while (true) {
                IRodinFile file;
                String id;
                if (n2 >= n) {
                    return false;
                }
                IRodinElement element = iRodinElementArray[n2];
                if (element instanceof IRodinFile && (id = (file = (IRodinFile)element).getRootElementType().getId()).startsWith("org.eventb.theory.core")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (RodinDBException e) {
            throw new TranslationFailedException((Exception)((Object)e));
        }
    }

    private void checkIfTheoriesAvailable() throws TranslationFailedException {
        try {
            Theories.touch();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new TranslationFailedException("Theory", "The model to animate makes use of a theory but the theory plug-in is not installed");
        }
    }

    private void translateTheories(IEventBProject project2, IPrologTermOutput pout) throws TranslationFailedException {
        Theories.translate(this.project, pout);
    }
}

