/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.translator.internal;

import de.prob.core.translator.TranslationFailedException;
import de.prob.eventb.translator.ContextTranslator;
import de.prob.eventb.translator.internal.EventBTranslator;
import de.prob.prolog.output.IPrologTermOutput;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eventb.core.IEventBRoot;
import org.eventb.core.ISCContext;
import org.eventb.core.ISCContextRoot;
import org.eventb.core.ISCExtendsContext;
import org.eventb.core.ISCInternalContext;

public final class EventBContextTranslator
extends EventBTranslator {
    private final ISCContext context;

    public static void create(ISCContextRoot context, IPrologTermOutput pto) throws TranslationFailedException {
        EventBContextTranslator translator = new EventBContextTranslator(context);
        translator.constructTranslation(pto);
    }

    public static void create(ISCInternalContext context, IPrologTermOutput pto) throws TranslationFailedException {
        EventBContextTranslator translator = new EventBContextTranslator(context);
        translator.constructTranslation(pto);
    }

    private EventBContextTranslator(ISCInternalContext context) {
        super(context);
        this.context = context;
    }

    private EventBContextTranslator(ISCContextRoot context) {
        super((IEventBRoot)context);
        this.context = context;
    }

    private void constructTranslation(IPrologTermOutput pto) throws TranslationFailedException {
        ArrayList<ContextTranslator> contextTranslators = new ArrayList<ContextTranslator>();
        if (this.context instanceof ISCContextRoot) {
            ISCContextRoot root = (ISCContextRoot)this.context;
            this.collectContexts(contextTranslators, new ArrayList<String>(), root);
        }
        this.printProlog(new ArrayList(), contextTranslators, pto);
    }

    private void collectContexts(List<ContextTranslator> translatorMap, List<String> processed, ISCContextRoot context) throws TranslationFailedException {
        String name = context.getElementName();
        if (!processed.contains(name)) {
            processed.add(name);
            translatorMap.add(ContextTranslator.create(context));
            try {
                ISCExtendsContext[] clauses;
                ISCExtendsContext[] iSCExtendsContextArray = clauses = context.getSCExtendsClauses();
                int n = clauses.length;
                int n2 = 0;
                while (n2 < n) {
                    ISCExtendsContext extendsContext = iSCExtendsContextArray[n2];
                    ISCContextRoot element = extendsContext.getAbstractSCContext();
                    this.collectContexts(translatorMap, processed, element);
                    ++n2;
                }
            }
            catch (CoreException e) {
                throw new TranslationFailedException((Exception)((Object)e));
            }
        }
    }
}

