/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.translator;

import de.be4.classicalb.core.parser.node.AAbstractConstantsContextClause;
import de.be4.classicalb.core.parser.node.AAxiomsContextClause;
import de.be4.classicalb.core.parser.node.AConstantsContextClause;
import de.be4.classicalb.core.parser.node.ADeferredSetSet;
import de.be4.classicalb.core.parser.node.ADescriptionExpression;
import de.be4.classicalb.core.parser.node.ADescriptionPragma;
import de.be4.classicalb.core.parser.node.ADescriptionPredicate;
import de.be4.classicalb.core.parser.node.ADescriptionSet;
import de.be4.classicalb.core.parser.node.AEventBContextParseUnit;
import de.be4.classicalb.core.parser.node.AExtendsContextClause;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.ASetsContextClause;
import de.be4.classicalb.core.parser.node.ATheoremsContextClause;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PContextClause;
import de.be4.classicalb.core.parser.node.PDescriptionPragma;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.PSet;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.node.TPragmaFreeText;
import de.hhu.stups.sablecc.patch.SourcePosition;
import de.prob.core.translator.TranslationFailedException;
import de.prob.eventb.translator.AbstractComponentTranslator;
import de.prob.eventb.translator.internal.EProofStatus;
import de.prob.eventb.translator.internal.ProofObligation;
import de.prob.eventb.translator.internal.SequentSource;
import de.prob.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eventb.core.EventBAttributes;
import org.eventb.core.IAxiom;
import org.eventb.core.ICarrierSet;
import org.eventb.core.IConstant;
import org.eventb.core.IContextRoot;
import org.eventb.core.IEventBRoot;
import org.eventb.core.IExtendsContext;
import org.eventb.core.ILabeledElement;
import org.eventb.core.IPOSequent;
import org.eventb.core.IPOSource;
import org.eventb.core.IPSRoot;
import org.eventb.core.IPSStatus;
import org.eventb.core.ISCAxiom;
import org.eventb.core.ISCCarrierSet;
import org.eventb.core.ISCConstant;
import org.eventb.core.ISCContext;
import org.eventb.core.ISCContextRoot;
import org.eventb.core.ISCExtendsContext;
import org.eventb.core.ISCIdentifierElement;
import org.eventb.core.ISCInternalContext;
import org.eventb.core.ISCPredicateElement;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.ITypeEnvironment;
import org.eventb.core.ast.ITypeEnvironmentBuilder;
import org.rodinp.core.IAttributeType;
import org.rodinp.core.IElementType;
import org.rodinp.core.IInternalElement;
import org.rodinp.core.IRodinElement;
import org.rodinp.core.IRodinFile;
import org.rodinp.core.IRodinProject;
import org.rodinp.core.RodinCore;
import org.rodinp.core.RodinDBException;

public final class ContextTranslator
extends AbstractComponentTranslator {
    private static final SourcePosition NO_POS = new SourcePosition(-1, -1);
    private final ISCContext context;
    private final AEventBContextParseUnit model = new AEventBContextParseUnit();
    private final Map<String, ISCContext> depContext = new HashMap<String, ISCContext>();
    private final IEventBRoot root;
    private final FormulaFactory ff;
    private final ITypeEnvironment te;

    public static ContextTranslator create(ISCContextRoot context) throws TranslationFailedException {
        try {
            ContextTranslator.assertConsistentModel((IInternalElement)context);
            FormulaFactory ff = context.getFormulaFactory();
            ITypeEnvironmentBuilder te = context.getTypeEnvironment();
            ContextTranslator translator = new ContextTranslator((ISCContext)context, ff, (ITypeEnvironment)te, (IEventBRoot)context);
            translator.translate();
            return translator;
        }
        catch (CoreException e) {
            throw ContextTranslator.createTranslationFailedException((ISCContext)context, e);
        }
    }

    public static ContextTranslator create(ISCInternalContext context, FormulaFactory ff, ITypeEnvironment te) throws TranslationFailedException {
        IEventBRoot root = ContextTranslator.getRootContext(context);
        ContextTranslator translator = new ContextTranslator((ISCContext)context, ff, te, root);
        try {
            ContextTranslator.assertConsistentModel(context.getRoot());
            translator.translate();
        }
        catch (CoreException e) {
            throw ContextTranslator.createTranslationFailedException((ISCContext)context, e);
        }
        return translator;
    }

    private static IEventBRoot getRootContext(ISCInternalContext context) {
        try {
            IInternalElement element;
            String elementName = context.getElementName();
            IRodinProject rodinProject = context.getRodinProject();
            IRodinFile rodinFile = rodinProject.getRodinFile(elementName + ".bcc");
            if (rodinFile.exists() && (element = rodinFile.getRoot()) instanceof IEventBRoot) {
                return (IEventBRoot)element;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private static TranslationFailedException createTranslationFailedException(ISCContext context, CoreException e) throws TranslationFailedException {
        return new TranslationFailedException(context.getComponentName(), "A Rodin exception occured during translation process. Possible cause: building aborted or still in progress. Please wait until building has finished before starting ProB. If this does not help, perform a clean and start ProB after building has finished. Original Exception: " + e.getLocalizedMessage());
    }

    private static boolean assertConsistentModel(IInternalElement machine_root) throws RodinDBException {
        return Assert.isTrue((boolean)machine_root.getRodinFile().isConsistent());
    }

    private ContextTranslator(ISCContext context, FormulaFactory ff, ITypeEnvironment te, IEventBRoot root) throws TranslationFailedException {
        super(context.getComponentName());
        this.context = context;
        this.ff = ff;
        this.te = te;
        this.root = root;
    }

    private void translate() throws CoreException {
        this.translateContext();
        this.collectProofInfo();
        this.collectPragmas();
    }

    private void collectPragmas() throws RodinDBException {
        this.addUnitPragmas((ISCIdentifierElement[])this.context.getSCConstants());
    }

    private void collectProofInfo() throws RodinDBException {
        if (this.root != null) {
            this.collectProofInfo(this.root);
        }
    }

    private void collectProofInfo(IEventBRoot origin) throws RodinDBException {
        LinkedList<String> bugs = new LinkedList<String>();
        try {
            IPSStatus[] statuses;
            IPSRoot proofStatus = origin.getPSRoot();
            IPSStatus[] iPSStatusArray = statuses = proofStatus.getStatuses();
            int n = statuses.length;
            int n2 = 0;
            while (n2 < n) {
                IPSStatus status = iPSStatusArray[n2];
                int confidence = status.getConfidence();
                boolean broken = status.isBroken();
                EProofStatus pstatus = EProofStatus.UNPROVEN;
                if (!broken && confidence == 500) {
                    pstatus = EProofStatus.REVIEWED;
                }
                if (!broken && confidence == 1000) {
                    pstatus = EProofStatus.PROVEN;
                }
                IPOSequent sequent = status.getPOSequent();
                IPOSource[] sources = sequent.getSources();
                String name = sequent.getDescription();
                ArrayList<SequentSource> s = new ArrayList<SequentSource>(sources.length);
                IPOSource[] iPOSourceArray = sources;
                int n3 = sources.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPOSource source = iPOSourceArray[n4];
                    IRodinElement srcElement = source.getSource();
                    if (!srcElement.exists() || !(srcElement instanceof ILabeledElement)) {
                        bugs.add(status.getElementName());
                        break;
                    }
                    ILabeledElement le = (ILabeledElement)srcElement;
                    s.add(new SequentSource((IElementType<? extends IRodinElement>)srcElement.getElementType(), le.getLabel()));
                    ++n4;
                }
                this.addProof(new ProofObligation(origin, s, name, pstatus));
                ++n2;
            }
        }
        catch (RodinDBException e) {
            bugs.add(e.getLocalizedMessage());
        }
        if (!bugs.isEmpty()) {
            String message = "Translation incomplete due to a Bug in Rodin. This does not affect correctness of the Animation/Model Checking but can decrease its performance. Skipped discharged information about: " + String.join((CharSequence)",", bugs);
            Logger.notifyUser(message);
        }
    }

    public AEventBContextParseUnit getContextAST() {
        return this.model;
    }

    public Map<String, ISCContext> getContextDependencies() {
        return this.depContext;
    }

    private void translateContext() throws CoreException {
        this.model.setName(new TIdentifierLiteral(this.context.getComponentName()));
        ArrayList<Object> clauses = new ArrayList<Object>();
        clauses.add(this.processExtends());
        clauses.addAll(this.processConstants());
        clauses.add(this.processAxioms());
        clauses.add(this.processTheorems());
        clauses.add(this.processSets());
        this.model.setContextClauses(clauses);
    }

    private AExtendsContextClause processExtends() throws CoreException {
        if (this.context instanceof ISCContextRoot) {
            return this.processExtendsForContextRoot();
        }
        if (this.context instanceof ISCInternalContext) {
            return this.processExtendsForInternalContext();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private AExtendsContextClause processExtendsForInternalContext() throws RodinDBException {
        ISCInternalContext icontext = (ISCInternalContext)this.context;
        IExtendsContext[] extendsClauses = (IExtendsContext[])icontext.getChildrenOfType((IElementType)IExtendsContext.ELEMENT_TYPE);
        try {
            extendsClauses = this.getSeenContexts(icontext);
        }
        catch (RodinDBException rodinDBException) {}
        ArrayList<TIdentifierLiteral> extendsList = new ArrayList<TIdentifierLiteral>(extendsClauses.length);
        IExtendsContext[] iExtendsContextArray = extendsClauses;
        int n = extendsClauses.length;
        int n2 = 0;
        while (n2 < n) {
            IExtendsContext extendsContext = iExtendsContextArray[n2];
            String name = extendsContext.getAbstractSCContext().getComponentName();
            extendsList.add(new TIdentifierLiteral(name));
            ++n2;
        }
        return new AExtendsContextClause(extendsList);
    }

    private IExtendsContext[] getSeenContexts(ISCInternalContext icontext) throws RodinDBException {
        String fname = icontext.getComponentName();
        IRodinFile file = icontext.getRodinProject().getRodinFile(fname + ".buc");
        IContextRoot root = (IContextRoot)file.getRoot();
        IExtendsContext[] extendsClauses = root.getExtendsClauses();
        return extendsClauses;
    }

    private AExtendsContextClause processExtendsForContextRoot() throws CoreException {
        ISCExtendsContext[] extendsClauses = null;
        ISCContextRoot rcontext = (ISCContextRoot)this.context;
        extendsClauses = rcontext.getSCExtendsClauses();
        ArrayList<TIdentifierLiteral> extendsList = new ArrayList<TIdentifierLiteral>(extendsClauses.length);
        ISCExtendsContext[] iSCExtendsContextArray = extendsClauses;
        int n = extendsClauses.length;
        int n2 = 0;
        while (n2 < n) {
            ISCExtendsContext extendsContext = iSCExtendsContextArray[n2];
            ISCContextRoot root = (ISCContextRoot)extendsContext.getAbstractSCContext().getRoot();
            String name = extendsContext.getAbstractSCContext().getComponentName();
            extendsList.add(new TIdentifierLiteral(name));
            this.depContext.put(name, (ISCContext)root);
            ++n2;
        }
        return new AExtendsContextClause(extendsList);
    }

    private ASetsContextClause processSets() throws RodinDBException {
        ISCCarrierSet[] carrierSets = this.context.getSCCarrierSets();
        ArrayList<Object> setList = new ArrayList<Object>(carrierSets.length);
        ISCCarrierSet[] iSCCarrierSetArray = carrierSets;
        int n = carrierSets.length;
        int n2 = 0;
        while (n2 < n) {
            ISCCarrierSet carrierSet = iSCCarrierSetArray[n2];
            ADeferredSetSet deferredSet = new ADeferredSetSet(Arrays.asList(new TIdentifierLiteral(carrierSet.getIdentifierString())));
            ICarrierSet ucs = (ICarrierSet)carrierSet.getSource();
            if (ucs.hasAttribute((IAttributeType)EventBAttributes.COMMENT_ATTRIBUTE)) {
                String commentString = ucs.getAttributeValue(EventBAttributes.COMMENT_ATTRIBUTE);
                TPragmaFreeText desc = new TPragmaFreeText(commentString);
                ADescriptionPragma descPragma = new ADescriptionPragma(Collections.singletonList(desc));
                ADescriptionSet descid = new ADescriptionSet((PDescriptionPragma)descPragma, (PSet)deferredSet);
                setList.add(descid);
            } else {
                setList.add(deferredSet);
            }
            ++n2;
        }
        return new ASetsContextClause(setList);
    }

    private List<PContextClause> processConstants() throws RodinDBException {
        ISCConstant[] constants = this.context.getSCConstants();
        ArrayList<Object> concreteConstants = new ArrayList<Object>(constants.length);
        ArrayList<Object> abstractConstants = new ArrayList<Object>(constants.length);
        ISCConstant[] iSCConstantArray = constants;
        int n = constants.length;
        int n2 = 0;
        while (n2 < n) {
            ISCConstant constant = iSCConstantArray[n2];
            boolean isAbstractConstant = false;
            try {
                IAttributeType.Boolean ATTRIBUTE = RodinCore.getBooleanAttrType((String)"de.prob.symbolic.symbolicAttribute");
                if (constant.hasAttribute((IAttributeType)ATTRIBUTE)) {
                    isAbstractConstant = constant.getAttributeValue(ATTRIBUTE);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            AIdentifierExpression cstid = new AIdentifierExpression(Arrays.asList(new TIdentifierLiteral(constant.getIdentifierString())));
            IConstant ucc = (IConstant)constant.getSource();
            if (ucc.hasAttribute((IAttributeType)EventBAttributes.COMMENT_ATTRIBUTE)) {
                String commentString = ucc.getAttributeValue(EventBAttributes.COMMENT_ATTRIBUTE);
                TPragmaFreeText desc = new TPragmaFreeText(commentString);
                ADescriptionPragma descPragma = new ADescriptionPragma(Collections.singletonList(desc));
                ADescriptionExpression descid = new ADescriptionExpression((PDescriptionPragma)descPragma, (PExpression)cstid);
                if (isAbstractConstant) {
                    abstractConstants.add(descid);
                } else {
                    concreteConstants.add(descid);
                }
            } else if (isAbstractConstant) {
                abstractConstants.add(cstid);
            } else {
                concreteConstants.add(cstid);
            }
            ++n2;
        }
        AConstantsContextClause constantsContextClause = new AConstantsContextClause();
        constantsContextClause.setIdentifiers(concreteConstants);
        AAbstractConstantsContextClause abstractConstantsClause = new AAbstractConstantsContextClause();
        abstractConstantsClause.setIdentifiers(abstractConstants);
        return Arrays.asList(constantsContextClause, abstractConstantsClause);
    }

    private ATheoremsContextClause processTheorems() throws CoreException {
        ISCAxiom[] axioms = this.context.getSCAxioms();
        ATheoremsContextClause theoremsContextClause = new ATheoremsContextClause();
        theoremsContextClause.setPredicates(this.extractPredicates(axioms, true));
        return theoremsContextClause;
    }

    private AAxiomsContextClause processAxioms() throws CoreException {
        ISCAxiom[] axioms = this.context.getSCAxioms();
        AAxiomsContextClause axiomsContextClause = new AAxiomsContextClause();
        axiomsContextClause.setPredicates(this.extractPredicates(axioms, false));
        return axiomsContextClause;
    }

    private List<PPredicate> extractPredicates(ISCAxiom[] predicates, boolean theorems) throws CoreException {
        ArrayList<PPredicate> list = new ArrayList<PPredicate>(predicates.length);
        ISCAxiom[] iSCAxiomArray = predicates;
        int n = predicates.length;
        int n2 = 0;
        while (n2 < n) {
            ISCAxiom element = iSCAxiomArray[n2];
            if (element.isTheorem() == theorems) {
                PPredicate predicate = this.translatePredicate(this.ff, this.te, (ISCPredicateElement)element);
                IAxiom uca = (IAxiom)element.getSource();
                if (uca.hasAttribute((IAttributeType)EventBAttributes.COMMENT_ATTRIBUTE)) {
                    String commentString = uca.getAttributeValue(EventBAttributes.COMMENT_ATTRIBUTE);
                    TPragmaFreeText desc = new TPragmaFreeText(commentString);
                    ADescriptionPragma descPragma = new ADescriptionPragma(Collections.singletonList(desc));
                    ADescriptionPredicate dpred = new ADescriptionPredicate((PDescriptionPragma)descPragma, predicate);
                    list.add((PPredicate)dpred);
                    this.labelMapping.put(dpred, element);
                } else {
                    list.add(predicate);
                    this.labelMapping.put(predicate, element);
                }
            }
            ++n2;
        }
        return list;
    }

    @Override
    public String getResource() {
        return this.context.getComponentName();
    }

    @Override
    public Node getAST() {
        return this.getContextAST();
    }
}

