/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.prolog;

import de.prob.core.types.BaseProbType;
import de.prob.core.types.CoupleProbType;
import de.prob.core.types.FreetypeProbType;
import de.prob.core.types.GivenSetProbType;
import de.prob.core.types.OperationProbType;
import de.prob.core.types.ProbDataType;
import de.prob.core.types.RecordProbType;
import de.prob.core.types.SequenceDataType;
import de.prob.core.types.SetProbType;
import de.prob.core.types.TypedIdentifier;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TypedIdentifierGenerator {
    private static final Map<String, Handler> handlers = TypedIdentifierGenerator.initHandlers();

    public static TypedIdentifier[] extract(ListPrologTerm list) {
        TypedIdentifier[] result = new TypedIdentifier[list.size()];
        int i = 0;
        while (i < list.size()) {
            PrologTerm element = list.get(i);
            if (!element.isTerm()) {
                throw TypedIdentifierGenerator.expectationFailed("list of compound terms", element);
            }
            result[i] = TypedIdentifierGenerator.extract((CompoundPrologTerm)element);
            ++i;
        }
        return result;
    }

    public static TypedIdentifier extract(CompoundPrologTerm term) {
        if (!term.hasFunctor("b", 3)) {
            throw TypedIdentifierGenerator.expectationFailed("b/3", (PrologTerm)term);
        }
        String name = TypedIdentifierGenerator.getIdentifier(term.getArgument(1));
        ProbDataType type = TypedIdentifierGenerator.extractType(term.getArgument(2));
        String[] sections = TypedIdentifierGenerator.extractSections(term.getArgument(3));
        TypedIdentifier typedIdentifier = new TypedIdentifier(name, type, sections);
        return typedIdentifier;
    }

    private static String[] extractSections(PrologTerm term) {
        if (term.isList()) {
            String[] sections = null;
            for (PrologTerm arg : (ListPrologTerm)term) {
                if (!arg.hasFunctor("occurrences", 1)) continue;
                PrologTerm psections = ((CompoundPrologTerm)arg).getArgument(1);
                if (psections.isList()) {
                    sections = TypedIdentifierGenerator.extractSectionsFromList((ListPrologTerm)psections);
                    continue;
                }
                throw TypedIdentifierGenerator.expectationFailed("list of sections", psections);
            }
            return sections;
        }
        throw TypedIdentifierGenerator.expectationFailed("list of identifier informations", term);
    }

    private static String[] extractSectionsFromList(ListPrologTerm psections) {
        String[] sections = new String[psections.size()];
        int i = 0;
        while (i < psections.size()) {
            PrologTerm term = psections.get(i);
            if (term.isAtom()) {
                sections[i] = ((CompoundPrologTerm)term).getFunctor();
            }
            ++i;
        }
        return sections;
    }

    public static ProbDataType extractType(PrologTerm aterm) {
        Handler handler;
        CompoundPrologTerm term;
        if (aterm.isTerm()) {
            term = (CompoundPrologTerm)aterm;
            String functor = term.getFunctor();
            String lookup = functor + "/" + term.getArity();
            handler = handlers.get(lookup);
            if (handler == null) {
                throw new IllegalArgumentException("unknown type handler for " + lookup);
            }
        } else {
            throw TypedIdentifierGenerator.expectationFailed("compound term", aterm);
        }
        ProbDataType type = handler.handle(term);
        return type;
    }

    private static String getIdentifier(PrologTerm term) {
        if (!term.hasFunctor("identifier", 1)) {
            throw TypedIdentifierGenerator.expectationFailed("identifier/1", term);
        }
        PrologTerm arg1 = ((CompoundPrologTerm)term).getArgument(1);
        String name = arg1.isAtom() ? PrologTerm.atomicString((PrologTerm)arg1) : arg1.toString();
        return name;
    }

    private static IllegalArgumentException expectationFailed(String expected, PrologTerm term) {
        return new IllegalArgumentException("expected " + expected + ", but was: " + term.toString());
    }

    private static Map<String, Handler> initHandlers() {
        HashMap<String, Handler> handlers = new HashMap<String, Handler>();
        handlers.put("integer/0", new BasicHandler(BaseProbType.INTEGER));
        handlers.put("float/0", new BasicHandler(BaseProbType.FLOAT));
        handlers.put("real/0", new BasicHandler(BaseProbType.REAL));
        handlers.put("string/0", new BasicHandler(BaseProbType.STRING));
        handlers.put("boolean/0", new BasicHandler(BaseProbType.BOOL));
        handlers.put("pred/0", new BasicHandler(BaseProbType.PREDICATE));
        handlers.put("subst/0", new BasicHandler(BaseProbType.SUBSTITUTION));
        handlers.put("any/0", new BasicHandler(BaseProbType.ANY));
        handlers.put("set/1", new SetHandler());
        handlers.put("seq/1", new SeqHandler());
        handlers.put("global/1", new GivenSetHandler());
        handlers.put("couple/2", new CoupleHandler());
        handlers.put("op/2", new OperationHandler());
        handlers.put("freetype/1", new FreetypeHandler());
        handlers.put("record/1", new RecordHandler());
        return Collections.unmodifiableMap(handlers);
    }

    private static String getString(PrologTerm term) {
        return term.isAtom() ? ((CompoundPrologTerm)term).getFunctor() : term.toString();
    }

    private static ProbDataType[] createList(PrologTerm term) {
        ProbDataType[] result;
        if (term instanceof ListPrologTerm) {
            ListPrologTerm list = (ListPrologTerm)term;
            result = new ProbDataType[list.size()];
            int i = 0;
            while (i < list.size()) {
                result[i] = TypedIdentifierGenerator.extractType(list.get(i));
                ++i;
            }
        } else {
            throw new IllegalArgumentException("expected list, but was: " + term.toString());
        }
        return result;
    }

    private static class BasicHandler
    implements Handler {
        private final ProbDataType type;

        public BasicHandler(ProbDataType type) {
            this.type = type;
        }

        @Override
        public ProbDataType handle(CompoundPrologTerm term) {
            return this.type;
        }
    }

    private static class CoupleHandler
    implements Handler {
        private CoupleHandler() {
        }

        @Override
        public ProbDataType handle(CompoundPrologTerm term) {
            return new CoupleProbType(TypedIdentifierGenerator.extractType(term.getArgument(1)), TypedIdentifierGenerator.extractType(term.getArgument(2)));
        }
    }

    private static class FreetypeHandler
    implements Handler {
        private FreetypeHandler() {
        }

        @Override
        public ProbDataType handle(CompoundPrologTerm term) {
            return new FreetypeProbType(TypedIdentifierGenerator.getString(term.getArgument(1)));
        }
    }

    private static class GivenSetHandler
    implements Handler {
        private GivenSetHandler() {
        }

        @Override
        public ProbDataType handle(CompoundPrologTerm term) {
            return new GivenSetProbType(TypedIdentifierGenerator.getString(term.getArgument(1)));
        }
    }

    private static interface Handler {
        public ProbDataType handle(CompoundPrologTerm var1);
    }

    private static class OperationHandler
    implements Handler {
        private OperationHandler() {
        }

        @Override
        public ProbDataType handle(CompoundPrologTerm term) {
            ProbDataType[] results = TypedIdentifierGenerator.createList(term.getArgument(1));
            ProbDataType[] params = TypedIdentifierGenerator.createList(term.getArgument(2));
            return new OperationProbType(results, params);
        }
    }

    private static class RecordHandler
    implements Handler {
        private RecordHandler() {
        }

        @Override
        public ProbDataType handle(CompoundPrologTerm term) {
            if (term.getArgument(1) instanceof ListPrologTerm) {
                ListPrologTerm list = (ListPrologTerm)term.getArgument(1);
                HashMap<String, ProbDataType> fields = new HashMap<String, ProbDataType>();
                int i = 0;
                while (i < list.size()) {
                    PrologTerm field = list.get(i);
                    if (!field.hasFunctor("field", 2)) {
                        throw new IllegalArgumentException("expected field/2, but was: " + field.toString());
                    }
                    CompoundPrologTerm cfield = (CompoundPrologTerm)field;
                    ProbDataType ftype = TypedIdentifierGenerator.extractType(cfield.getArgument(2));
                    fields.put(TypedIdentifierGenerator.getString(cfield.getArgument(1)), ftype);
                    ++i;
                }
                return new RecordProbType(fields);
            }
            throw new IllegalArgumentException("expected field list, but was: " + term.toString());
        }
    }

    private static class SeqHandler
    implements Handler {
        private SeqHandler() {
        }

        @Override
        public ProbDataType handle(CompoundPrologTerm term) {
            return new SequenceDataType(TypedIdentifierGenerator.extractType(term.getArgument(1)));
        }
    }

    private static class SetHandler
    implements Handler {
        private SetHandler() {
        }

        @Override
        public ProbDataType handle(CompoundPrologTerm term) {
            return new SetProbType(TypedIdentifierGenerator.extractType(term.getArgument(1)));
        }
    }
}

