/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.internal;

import de.prob.core.IAnimationListener;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class AnimationListenerProxy
implements IAnimationListener {
    private final IConfigurationElement config;
    private IAnimationListener instance;

    public AnimationListenerProxy(IConfigurationElement config) {
        this.config = config;
    }

    @Override
    public void currentStateChanged(State currentState, Operation operation) {
        if (this.instance == null) {
            this.instance = this.init();
        }
        if (this.instance != null) {
            this.instance.currentStateChanged(currentState, operation);
        }
    }

    private IAnimationListener init() {
        try {
            return (IAnimationListener)this.config.createExecutableExtension("class");
        }
        catch (CoreException e) {
            Logger.notifyUser("A Listener could not be instatiated. Class is: " + this.config.getAttribute("class"), e);
            e.printStackTrace();
            return null;
        }
    }
}

