/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.internal;

import de.prob.core.Animator;
import de.prob.core.IAnimationListener;
import de.prob.core.IComputationListener;
import de.prob.core.ILifecycleListener;
import de.prob.core.LimitedLogger;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.core.internal.AnimationListenerProxy;
import de.prob.core.internal.ComputationListenerProxy;
import de.prob.core.internal.LifeCycleListenerProxy;
import de.prob.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.osgi.framework.BundleContext;

public final class Activator
extends Plugin {
    public static final String PLUGIN_ID = "de.prob.core";
    private static final String ANIMATION_EXTENSION_POINT = "de.prob.core.animation";
    private static final String COMPUTATION_EXTENSION_POINT = "de.prob.core.computation";
    private static final String LIFECYCLE_EXTENSION_POINT = "de.prob.core.lifecycle";
    private static final Set<ILifecycleListener> lifeCycleListeners = Activator.initLifeCycleListeners();
    private static final Set<IComputationListener> computationListeners = Activator.initComputationListeners();
    private static final Set<IAnimationListener> animationListeners = Activator.initAnimationListeners();
    private static Activator plugin = null;
    private final Collection<Job> jobs = new ArrayList<Job>();
    private final IJobChangeListener jobFinishedListener = new JobFinishedListener();

    private static Set<ILifecycleListener> initLifeCycleListeners() {
        HashSet<ILifecycleListener> result = new HashSet<ILifecycleListener>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(LIFECYCLE_EXTENSION_POINT);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                result.add(new LifeCycleListenerProxy(configurationElement));
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private static Set<IComputationListener> initComputationListeners() {
        HashSet<IComputationListener> result = new HashSet<IComputationListener>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(COMPUTATION_EXTENSION_POINT);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                result.add(new ComputationListenerProxy(configurationElement));
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private static Set<IAnimationListener> initAnimationListeners() {
        HashSet<IAnimationListener> result = new HashSet<IAnimationListener>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(ANIMATION_EXTENSION_POINT);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                result.add(new AnimationListenerProxy(configurationElement));
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Set<ILifecycleListener> set = lifeCycleListeners;
        synchronized (set) {
            LimitedLogger logger = LimitedLogger.getLogger();
            logger.log("lifecycle", "start announcing reset", null);
            for (ILifecycleListener l : lifeCycleListeners) {
                try {
                    l.reset();
                }
                catch (RuntimeException e) {
                    String message = "Runtime Exception thrown in bad behaving listener class " + String.valueOf(l.getClass()) + " while sending reset event";
                    Logger.notifyUser(message, e);
                }
            }
            logger.log("lifecycle", "finished announcing reset", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void computedState(State state) {
        Set<IComputationListener> set = computationListeners;
        synchronized (set) {
            String stateId = state == null ? null : state.getId();
            LimitedLogger logger = LimitedLogger.getLogger();
            logger.log("lifecycle", "start announcing computed state " + stateId, null);
            for (IComputationListener l : computationListeners) {
                try {
                    l.computedState(state);
                }
                catch (RuntimeException e) {
                    String message = "Runtime Exception thrown in bad behaving listener class " + String.valueOf(l.getClass()) + " while sending computation event.";
                    Logger.notifyUser(message, e);
                }
            }
            logger.log("lifecycle", "finished announcing computed state " + stateId, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void currentStateChanged(State currentState, Operation operation) {
        Set<IAnimationListener> set = animationListeners;
        synchronized (set) {
            String stateId = currentState == null ? null : currentState.getId();
            LimitedLogger logger = LimitedLogger.getLogger();
            logger.log("lifecycle", "start announcing current state " + stateId, null);
            for (IAnimationListener l : animationListeners) {
                try {
                    l.currentStateChanged(currentState, operation);
                }
                catch (RuntimeException e) {
                    String message = "Runtime Exception thrown in bad behaving listener class " + String.valueOf(l.getClass()) + " while sending state change event";
                    Logger.notifyUser(message, e);
                }
            }
            logger.log("lifecycle", "finished announcing current state " + stateId, null);
        }
    }

    public Activator() {
        Activator.setInstance(this);
    }

    private static void setInstance(Activator p) {
        plugin = p;
    }

    public void stop(BundleContext context) throws Exception {
        this.cancelAllJobs();
        Animator animator = Animator.getAnimator();
        if (animator != null) {
            animator.sendUserInterruptSignal();
            animator.shutdown();
        }
        plugin = null;
        super.stop(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllJobs() {
        Collection<Job> collection = this.jobs;
        synchronized (collection) {
            for (Job job : this.jobs) {
                job.cancel();
            }
        }
    }

    public static Activator getDefault() {
        if (plugin == null) {
            new Activator();
        }
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerJob(Job job) {
        Collection<Job> collection = this.jobs;
        synchronized (collection) {
            this.jobs.add(job);
            job.addJobChangeListener(this.jobFinishedListener);
        }
    }

    private class JobFinishedListener
    extends JobChangeAdapter {
        private JobFinishedListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            super.done(event);
            Collection<Job> collection = Activator.this.jobs;
            synchronized (collection) {
                Activator.this.jobs.remove(event.getJob());
            }
        }
    }
}

