/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.ltl;

import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExamplePredicate;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleSince;
import de.prob.core.domainobjects.ltl.CounterExampleUnaryOperator;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CounterExampleOnce
extends CounterExampleUnaryOperator {
    public CounterExampleOnce(CounterExample counterExample, CounterExampleProposition argument) {
        super("O", "Once", counterExample, argument);
        this.checkBySince(counterExample, argument);
    }

    private void checkBySince(CounterExample counterExample, CounterExampleProposition argument) {
        CounterExampleValueType[] firstValues = new CounterExampleValueType[argument.getValues().size()];
        Arrays.fill((Object[])firstValues, (Object)CounterExampleValueType.TRUE);
        CounterExamplePredicate first = new CounterExamplePredicate("", counterExample, Arrays.asList(firstValues));
        this.addCheck(new CounterExampleSince(counterExample, first, argument));
    }

    @Override
    public CounterExampleValueType calculate(int position) {
        return this.calculateOnceOperator(position);
    }

    private CounterExampleValueType calculateOnceOperator(int position) {
        CounterExampleValueType result = CounterExampleValueType.UNKNOWN;
        List<CounterExampleValueType> checkedValues = new ArrayList<CounterExampleValueType>(this.argument.getValues());
        int index = (checkedValues = checkedValues.subList(0, position + 1)).lastIndexOf((Object)CounterExampleValueType.TRUE);
        if (index != -1) {
            result = CounterExampleValueType.TRUE;
        } else if (!checkedValues.contains((Object)CounterExampleValueType.UNKNOWN)) {
            result = CounterExampleValueType.FALSE;
        }
        this.fillHighlightedPositions(position, index, checkedValues.size(), true);
        return result;
    }
}

