/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.ltl;

import de.prob.core.command.LtlCheckingCommand;
import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleUnaryOperator;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;
import java.util.ArrayList;
import java.util.List;

public final class CounterExampleNext
extends CounterExampleUnaryOperator {
    public CounterExampleNext(CounterExample counterExample, CounterExampleProposition argument) {
        super("X", "Next", counterExample, argument);
    }

    @Override
    public CounterExampleValueType calculate(int position) {
        return this.calculateNextOperator(position);
    }

    private CounterExampleValueType calculateNextOperator(int position) {
        CounterExampleValueType result = CounterExampleValueType.UNKNOWN;
        List<CounterExampleValueType> checkedValues = new ArrayList<CounterExampleValueType>(this.argument.getValues());
        if (this.pathType == LtlCheckingCommand.PathType.INFINITE && position > this.loopEntry) {
            checkedValues.addAll(checkedValues.subList(this.loopEntry, position));
        }
        checkedValues = checkedValues.subList(position, checkedValues.size());
        int index = -1;
        if (checkedValues.size() > 1) {
            index = 1;
            result = checkedValues.get(index);
        } else if (this.pathType == LtlCheckingCommand.PathType.FINITE) {
            result = CounterExampleValueType.FALSE;
        } else if (this.pathType == LtlCheckingCommand.PathType.INFINITE) {
            index = 0;
            result = checkedValues.get(0);
        }
        this.fillHighlightedPositions(position, index, -1, false);
        return result;
    }
}

