/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.ltl;

import de.prob.core.command.LtlCheckingCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.ltl.CounterExampleBinaryOperator;
import de.prob.core.domainobjects.ltl.CounterExampleConjunction;
import de.prob.core.domainobjects.ltl.CounterExampleDisjunction;
import de.prob.core.domainobjects.ltl.CounterExampleFinally;
import de.prob.core.domainobjects.ltl.CounterExampleGlobally;
import de.prob.core.domainobjects.ltl.CounterExampleHistory;
import de.prob.core.domainobjects.ltl.CounterExampleImplication;
import de.prob.core.domainobjects.ltl.CounterExampleNegation;
import de.prob.core.domainobjects.ltl.CounterExampleNext;
import de.prob.core.domainobjects.ltl.CounterExampleOnce;
import de.prob.core.domainobjects.ltl.CounterExamplePredicate;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleRelease;
import de.prob.core.domainobjects.ltl.CounterExampleSince;
import de.prob.core.domainobjects.ltl.CounterExampleState;
import de.prob.core.domainobjects.ltl.CounterExampleTransition;
import de.prob.core.domainobjects.ltl.CounterExampleTrigger;
import de.prob.core.domainobjects.ltl.CounterExampleUnaryOperator;
import de.prob.core.domainobjects.ltl.CounterExampleUntil;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;
import de.prob.core.domainobjects.ltl.CounterExampleWeakUntil;
import de.prob.core.domainobjects.ltl.CounterExampleYesterday;
import de.prob.logging.Logger;
import de.prob.prolog.term.AIntegerPrologTerm;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CounterExample {
    private static final PrologTerm NONE = new CompoundPrologTerm("none");
    private final CounterExampleProposition propositionRoot;
    private final List<CounterExampleProposition> propositions = new ArrayList<CounterExampleProposition>();
    private final List<CounterExampleState> states = new ArrayList<CounterExampleState>();
    private final int loopEntry;
    private final List<Operation> initPath;
    private final LtlCheckingCommand.PathType pathType;
    private final int ceSize;

    protected CounterExample(CounterExampleProposition propositionRoot, int loopEntry, List<Operation> initPath, LtlCheckingCommand.PathType pathType, int ceSize) {
        this.propositionRoot = propositionRoot;
        this.loopEntry = loopEntry;
        this.initPath = initPath;
        this.pathType = pathType;
        this.ceSize = ceSize;
    }

    public CounterExample(LtlCheckingCommand.Result modelCheckingResult) {
        this.loopEntry = modelCheckingResult.getLoopEntry();
        this.pathType = modelCheckingResult.getPathType();
        this.initPath = Collections.unmodifiableList(Arrays.asList(modelCheckingResult.getInitPathOps()));
        this.ceSize = modelCheckingResult.getCounterexample().size();
        String[] atomicFormulaNames = this.createAtomicNames(modelCheckingResult);
        List<ArrayList<Boolean>> predicateValues = this.createStates(modelCheckingResult.getCounterexample(), atomicFormulaNames);
        this.propositionRoot = this.createExample(modelCheckingResult.getStructure(), atomicFormulaNames, predicateValues);
        this.propositionRoot.setVisible(true);
        Collections.reverse(this.propositions);
    }

    private String[] createAtomicNames(LtlCheckingCommand.Result modelCheckingResult) {
        String[] res = new String[modelCheckingResult.getAtomics().size()];
        int i = 0;
        for (PrologTerm term : modelCheckingResult.getAtomics()) {
            res[i] = PrologTerm.atomicString((PrologTerm)((CompoundPrologTerm)term).getArgument(1));
            ++i;
        }
        return res;
    }

    private List<ArrayList<Boolean>> createStates(ListPrologTerm example, String[] atomicFormulaNames) {
        ArrayList<ArrayList<Boolean>> predicateValues = new ArrayList<ArrayList<Boolean>>();
        int i = 0;
        while (i < atomicFormulaNames.length) {
            predicateValues.add(new ArrayList());
            ++i;
        }
        int index = 0;
        for (PrologTerm exampleElement : example) {
            CompoundPrologTerm state = (CompoundPrologTerm)exampleElement;
            PrologTerm stateId = state.getArgument(1);
            ListPrologTerm values = (ListPrologTerm)state.getArgument(2);
            CompoundPrologTerm operationTerm = (CompoundPrologTerm)state.getArgument(3);
            int i2 = 0;
            while (i2 < values.size()) {
                int value = ((AIntegerPrologTerm)values.get(i2)).intValueExact();
                ((ArrayList)predicateValues.get(i2)).add(value != 0);
                ++i2;
            }
            Operation operation = NONE.equals(operationTerm) ? null : Operation.fromPrologTerm((PrologTerm)operationTerm);
            CounterExampleState ceState = new CounterExampleState(index, stateId, operation);
            this.states.add(ceState);
            ++index;
        }
        return predicateValues;
    }

    private CounterExampleProposition createExample(PrologTerm structure, String[] atomicFormulaNames, List<ArrayList<Boolean>> predicateValues) {
        CounterExampleProposition proposition;
        CompoundPrologTerm term = (CompoundPrologTerm)structure;
        String functor = term.getFunctor();
        int arity = term.getArity();
        CounterExampleValueType[] values = new CounterExampleValueType[this.states.size()];
        if (arity == 0) {
            if (functor.equals("true")) {
                Arrays.fill((Object[])values, (Object)CounterExampleValueType.TRUE);
            } else if (functor.equals("false")) {
                Arrays.fill((Object[])values, (Object)CounterExampleValueType.FALSE);
            }
            proposition = new CounterExamplePredicate(functor, this, Arrays.asList(values));
        } else if (arity == 1) {
            if (functor.equals("ap") || functor.equals("tp")) {
                AIntegerPrologTerm atomic = (AIntegerPrologTerm)term.getArgument(1);
                int atomicId = atomic.intValueExact();
                String name = atomicFormulaNames[atomicId];
                int atomicIdSize = predicateValues.get(atomicId).size();
                Logger.assertProB("CounterExampleProposition invalid, expected values.length = " + values.length + ", got term with: " + atomicIdSize + " values; Prolog term = " + term.toString(), values.length == atomicIdSize);
                int i = 0;
                while (i < atomicIdSize) {
                    values[i] = predicateValues.get(atomicId).get(i) != false ? CounterExampleValueType.TRUE : CounterExampleValueType.FALSE;
                    ++i;
                }
                proposition = functor.equals("ap") ? new CounterExamplePredicate(name, this, Arrays.asList(values)) : new CounterExampleTransition(name, this, Arrays.asList(values));
            } else {
                proposition = this.createUnaryOperator(atomicFormulaNames, predicateValues, term, functor);
            }
        } else if (arity == 2) {
            proposition = this.createBinaryOperator(atomicFormulaNames, predicateValues, term, functor);
        } else {
            throw new IllegalArgumentException("Unexpected Prolog LTL " + arity + "-ary operator " + functor);
        }
        this.propositions.add(proposition);
        return proposition;
    }

    private CounterExampleProposition createBinaryOperator(String[] atomicFormulaNames, List<ArrayList<Boolean>> predicateValues, CompoundPrologTerm term, String functor) {
        CounterExampleBinaryOperator proposition;
        CounterExampleProposition firstArgument = this.createExample(term.getArgument(1), atomicFormulaNames, predicateValues);
        CounterExampleProposition secondArgument = this.createExample(term.getArgument(2), atomicFormulaNames, predicateValues);
        if (functor.equals("and")) {
            proposition = new CounterExampleConjunction(this, firstArgument, secondArgument);
        } else if (functor.equals("or")) {
            proposition = new CounterExampleDisjunction(this, firstArgument, secondArgument);
        } else if (functor.equals("implies")) {
            proposition = new CounterExampleImplication(this, firstArgument, secondArgument);
        } else if (functor.equals("until")) {
            proposition = new CounterExampleUntil(this, firstArgument, secondArgument);
        } else if (functor.equals("weakuntil")) {
            proposition = new CounterExampleWeakUntil(this, firstArgument, secondArgument);
        } else if (functor.equals("release")) {
            proposition = new CounterExampleRelease(this, firstArgument, secondArgument);
        } else if (functor.equals("since")) {
            proposition = new CounterExampleSince(this, firstArgument, secondArgument);
        } else if (functor.equals("trigger")) {
            proposition = new CounterExampleTrigger(this, firstArgument, secondArgument);
        } else {
            throw new IllegalArgumentException("Unexpected Prolog LTL binary operator " + functor);
        }
        firstArgument.setParent(proposition);
        secondArgument.setParent(proposition);
        return proposition;
    }

    private CounterExampleProposition createUnaryOperator(String[] atomicFormulaNames, List<ArrayList<Boolean>> predicateValues, CompoundPrologTerm term, String functor) {
        CounterExampleUnaryOperator proposition;
        CounterExampleProposition argument = this.createExample(term.getArgument(1), atomicFormulaNames, predicateValues);
        if (functor.equals("globally")) {
            proposition = new CounterExampleGlobally(this, argument);
        } else if (functor.equals("finally")) {
            proposition = new CounterExampleFinally(this, argument);
        } else if (functor.equals("next")) {
            proposition = new CounterExampleNext(this, argument);
        } else if (functor.equals("not")) {
            proposition = new CounterExampleNegation(this, argument);
        } else if (functor.equals("once")) {
            proposition = new CounterExampleOnce(this, argument);
        } else if (functor.equals("yesterday")) {
            proposition = new CounterExampleYesterday(this, argument);
        } else if (functor.equals("historically")) {
            proposition = new CounterExampleHistory(this, argument);
        } else {
            throw new IllegalArgumentException("Unexpected Prolog LTL unary operator " + functor);
        }
        argument.setParent(proposition);
        return proposition;
    }

    public CounterExampleProposition getPropositionRoot() {
        return this.propositionRoot;
    }

    public List<CounterExampleProposition> getPropositions() {
        return this.propositions;
    }

    public List<CounterExampleState> getStates() {
        return this.states;
    }

    public LtlCheckingCommand.PathType getPathType() {
        return this.pathType;
    }

    public int getLoopEntry() {
        return this.loopEntry;
    }

    public List<Operation> getFullPath() {
        ArrayList<Operation> fullPath = new ArrayList<Operation>(this.initPath);
        for (CounterExampleState ceState : this.states) {
            Operation operation = ceState.getOperation();
            if (operation == null) continue;
            fullPath.add(operation);
        }
        return fullPath;
    }

    public List<Operation> getInitPath() {
        return this.initPath;
    }

    public int getCounterExampleSize() {
        return this.ceSize;
    }
}

