/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.eval;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.exceptions.BException;
import de.be4.classicalb.core.parser.node.AConjunctPredicate;
import de.be4.classicalb.core.parser.node.ADisjunctPredicate;
import de.be4.classicalb.core.parser.node.AEquivalencePredicate;
import de.be4.classicalb.core.parser.node.AExistsPredicate;
import de.be4.classicalb.core.parser.node.AForallPredicate;
import de.be4.classicalb.core.parser.node.AImplicationPredicate;
import de.be4.classicalb.core.parser.node.ANegationPredicate;
import de.be4.classicalb.core.parser.node.APredicateParseUnit;
import de.be4.classicalb.core.parser.node.EOF;
import de.be4.classicalb.core.parser.node.PParseUnit;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.node.Switch;
import de.prob.core.domainobjects.eval.AbstractEvalElement;
import de.prob.eventb.translator.internal.TranslationVisitor;
import org.eventb.core.ast.Predicate;

public class PredicateEvalElement
extends AbstractEvalElement {
    private final Start parse;
    private final String predicate;

    public static PredicateEvalElement fromRodin(Predicate predicate) throws BCompoundException {
        if (predicate == null) {
            String message = "Predicate input must not be null";
            throw new BCompoundException(new BException("", message, (Throwable)new NullPointerException(message)));
        }
        PPredicate apred = TranslationVisitor.translatePredicate(predicate);
        APredicateParseUnit ppu = new APredicateParseUnit(apred);
        Start start = new Start((PParseUnit)ppu, new EOF());
        return new PredicateEvalElement(predicate, start);
    }

    public static PredicateEvalElement create(String predicate) throws BCompoundException {
        return new PredicateEvalElement(predicate);
    }

    private PredicateEvalElement(String predicate) throws BCompoundException {
        this.predicate = predicate;
        this.parse = this.parse("#PREDICATE", predicate);
    }

    private PredicateEvalElement(Predicate p, Start start) {
        this.predicate = p.toString();
        this.parse = start;
    }

    @Override
    public Start getPrologAst() {
        return this.parse;
    }

    @Override
    public boolean hasChildren() {
        ChildScanner scanner = new ChildScanner();
        this.parse.apply((Switch)scanner);
        return scanner.hasChildren;
    }

    @Override
    public String getLabel() {
        return this.predicate;
    }

    private static class ChildScanner
    extends DepthFirstAdapter {
        public boolean hasChildren;

        private ChildScanner() {
        }

        public void inAConjunctPredicate(AConjunctPredicate node) {
            this.hasChildren = true;
        }

        public void inANegationPredicate(ANegationPredicate node) {
            this.hasChildren = true;
        }

        public void inADisjunctPredicate(ADisjunctPredicate node) {
            this.hasChildren = true;
        }

        public void inAImplicationPredicate(AImplicationPredicate node) {
            this.hasChildren = true;
        }

        public void inAEquivalencePredicate(AEquivalencePredicate node) {
            this.hasChildren = true;
        }

        public void inAForallPredicate(AForallPredicate node) {
            this.hasChildren = true;
        }

        public void inAExistsPredicate(AExistsPredicate arg0) {
            this.hasChildren = true;
        }
    }
}

