/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects;

import de.prob.core.Animator;
import de.prob.core.command.EvaluationExpandCommand;
import de.prob.core.command.EvaluationGetValuesCommand;
import de.prob.core.domainobjects.EvaluationStateElement;
import de.prob.core.domainobjects.State;
import de.prob.exceptions.ProBException;
import de.prob.prolog.term.PrologTerm;
import de.prob.unicode.UnicodeTranslator;
import java.util.List;

public class EvaluationElement {
    private final PrologTerm id;
    private final Animator animator;
    private final EvaluationElement parent;
    private EvLazyInformation lazy;

    public EvaluationElement(Animator animator, PrologTerm id, EvaluationElement parent) {
        this.id = id;
        this.animator = animator;
        this.parent = parent;
    }

    public EvaluationElement(Animator animator, PrologTerm id, String label, List<PrologTerm> childrenIds) {
        this(animator, id, null);
        EvaluationElement[] children = new EvaluationElement[childrenIds.size()];
        int i = 0;
        for (PrologTerm childId : childrenIds) {
            children[i] = new EvaluationElement(animator, childId, this);
            ++i;
        }
        this.lazy = new EvLazyInformation(label, children);
    }

    public PrologTerm getId() {
        return this.id;
    }

    public EvaluationElement getParent() {
        return this.parent;
    }

    public EvaluationElement[] getChildren() throws ProBException {
        this.checkForLazyInformation();
        return this.lazy.children;
    }

    public String getLabel() throws ProBException {
        this.checkForLazyInformation();
        return this.lazy.label;
    }

    public EvaluationStateElement evaluateForState(State state) throws ProBException {
        return EvaluationGetValuesCommand.getSingleValueCached(state, this);
    }

    private void checkForLazyInformation() throws ProBException {
        if (this.lazy == null) {
            EvaluationExpandCommand cmd = new EvaluationExpandCommand(this.id);
            this.animator.execute(cmd);
            List<PrologTerm> childIds = cmd.getChildrenIds();
            EvaluationElement[] children = new EvaluationElement[childIds.size()];
            int i = 0;
            for (PrologTerm childId : childIds) {
                children[i] = new EvaluationElement(this.animator, childId, this);
                ++i;
            }
            String label = cmd.getLabel();
            this.lazy = new EvLazyInformation(label, children);
        }
    }

    public int hashCode() {
        return 31 + this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.id.equals(((EvaluationElement)obj).id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EvaluationElement[id=").append(this.id);
        if (this.lazy == null) {
            sb.append(",label not yet loaded]");
        } else {
            sb.append(",label='").append(this.lazy.label).append("']");
        }
        return sb.toString();
    }

    private static final class EvLazyInformation {
        private final String label;
        private final EvaluationElement[] children;

        public EvLazyInformation(String label, EvaluationElement[] children) {
            this.label = UnicodeTranslator.toUnicode((String)label);
            this.children = children;
        }
    }
}

