/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.ExecuteOperationCommand;
import de.prob.core.command.ExploreStateCommand;
import de.prob.core.command.GetFullTraceCommand;
import de.prob.core.command.SetStateCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.exceptions.ProBException;
import java.util.Iterator;
import java.util.List;

public final class ReplayTraceCommand {
    private static final String ROOT = "root";

    private ReplayTraceCommand() {
    }

    public static void replay(Animator animator) throws ProBException {
        GetFullTraceCommand.TraceResult trace = GetFullTraceCommand.getTrace(animator);
        animator.getHistory().reset();
        ExploreStateCommand.exploreState(animator, ROOT);
        SetStateCommand.setState(animator, ROOT);
        Iterator<String> it = trace.getStates().iterator();
        while (it.hasNext()) {
            String nextState = it.next();
            State state = animator.getCurrentState();
            Operation op = ReplayTraceCommand.getOperationByDstId(nextState, state.getEnabledOperations());
            boolean silent = it.hasNext();
            ExecuteOperationCommand.executeOperation(animator, op, silent);
        }
    }

    private static Operation getOperationByDstId(String dstId, List<Operation> operations) {
        for (Operation op : operations) {
            if (!op.getDestination().equals(dstId)) continue;
            return op;
        }
        return null;
    }
}

