/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;

public class QuickDescribeUnsatPropertiesCommand
implements IComposableCommand {
    public static final String OUTPUT_VARIABLE = "Output";
    private boolean unsatPropertiesExist;
    private String description;

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        if (((PrologTerm)bindings.get((Object)OUTPUT_VARIABLE)).hasFunctor("no_unsat_properties_found", 0)) {
            this.unsatPropertiesExist = false;
            this.description = "";
        } else {
            this.unsatPropertiesExist = true;
            ListPrologTerm outputStrings = (ListPrologTerm)((PrologTerm)bindings.get((Object)OUTPUT_VARIABLE)).getArgument(1);
            StringBuilder sb = new StringBuilder();
            for (PrologTerm p : outputStrings) {
                if (p.isAtom()) {
                    sb.append(PrologTerm.atomicString((PrologTerm)p));
                    continue;
                }
                sb.append(p.toString());
            }
            this.description = sb.toString().replace(";", "\n");
        }
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("quick_describe_unsat_properties").printVariable(OUTPUT_VARIABLE).closeTerm();
    }

    public boolean unsatPropertiesExist() {
        return this.unsatPropertiesExist;
    }

    public String getUnsatPropertiesDescription() {
        return this.description;
    }
}

