/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.command.ModelCheckingResult;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.AIntegerPrologTerm;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.List;

public final class ModelCheckingCommand
implements IComposableCommand {
    private final int time;
    private final List<String> options;
    private ModelCheckingResult<Result> result;

    ModelCheckingCommand(int time, List<String> options) {
        this.time = time;
        this.options = options;
    }

    public static ModelCheckingResult<Result> modelcheck(Animator a, int time, List<String> options) throws ProBException {
        ModelCheckingCommand command = new ModelCheckingCommand(time, options);
        a.execute(command);
        return command.getResult();
    }

    private ModelCheckingResult<Result> getResult() {
        return this.result;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        CompoundPrologTerm term = (CompoundPrologTerm)bindings.get((Object)"Result");
        CompoundPrologTerm stats = (CompoundPrologTerm)bindings.get((Object)"Stats");
        int processedTotal = ((AIntegerPrologTerm)stats.getArgument(3)).intValueExact();
        int numStates = ((AIntegerPrologTerm)stats.getArgument(1)).intValueExact();
        int numTransitions = ((AIntegerPrologTerm)stats.getArgument(2)).intValueExact();
        this.result = new ModelCheckingResult<Result>(Result.class, term, processedTotal, numStates, numTransitions);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("do_modelchecking").printNumber((long)this.time).openList();
        for (String o : this.options) {
            pto.printAtom(o);
        }
        pto.closeList().printVariable("Result");
        pto.printVariable("Stats").closeTerm();
    }

    public static enum Result {
        ok(true),
        ok_not_all_nodes_considered(true),
        deadlock(true),
        invariant_violation(true),
        assertion_violation(true),
        not_yet_finished(false),
        state_error(true),
        well_definedness_error(true),
        general_error(true),
        full_coverage(true);

        private final boolean abort;

        private Result(boolean abort) {
            this.abort = abort;
        }

        public boolean isAbort() {
            return this.abort;
        }
    }
}

