/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.StateError;
import de.prob.exceptions.ProBException;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.parser.ResultParserException;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GetStateBasedErrorsCommand
implements IComposableCommand {
    private final String stateId;
    private Collection<StateError> stateErrors;

    public GetStateBasedErrorsCommand(String stateId) {
        this.stateId = stateId;
    }

    public static Collection<StateError> getStateValues(Animator a, String id) throws ProBException {
        GetStateBasedErrorsCommand command = new GetStateBasedErrorsCommand(id);
        a.execute(command);
        return command.getResult();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        List errors;
        ListPrologTerm list;
        try {
            list = BindingGenerator.getList(bindings, (String)"Errors");
        }
        catch (ResultParserException e) {
            CommandException commandException = new CommandException(e.getLocalizedMessage(), e);
            commandException.notifyUserOnce();
            throw commandException;
        }
        if (list.isEmpty()) {
            errors = Collections.emptyList();
        } else {
            errors = new ArrayList();
            for (PrologTerm term : list) {
                CompoundPrologTerm compoundTerm;
                try {
                    compoundTerm = BindingGenerator.getCompoundTerm((PrologTerm)term, (String)"error", (int)3);
                }
                catch (ResultParserException e) {
                    CommandException commandException = new CommandException(e.getLocalizedMessage(), e);
                    commandException.notifyUserOnce();
                    throw commandException;
                }
                errors.add(new StateError(compoundTerm));
            }
        }
        this.stateErrors = errors;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("get_state_errors").printAtomOrNumber(this.stateId).printVariable("Errors").closeTerm();
    }

    public Collection<StateError> getResult() {
        return this.stateErrors;
    }
}

