/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.ProBPreference;
import de.prob.exceptions.ProBException;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.parser.ResultParserException;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.List;

public final class GetPreferencesCommand
implements IComposableCommand {
    private static final String PREFS_VARIABLE = "Prefs";
    private List<ProBPreference> prefs;

    private GetPreferencesCommand() {
    }

    public static List<ProBPreference> getPreferences(Animator animator) throws ProBException {
        GetPreferencesCommand getPreferencesCommand = new GetPreferencesCommand();
        animator.execute(getPreferencesCommand);
        return getPreferencesCommand.getPrefs();
    }

    private List<ProBPreference> getPrefs() {
        return this.prefs;
    }

    private ProBPreference verifyTerm(PrologTerm term) throws CommandException {
        CompoundPrologTerm compoundTerm;
        try {
            compoundTerm = BindingGenerator.getCompoundTerm((PrologTerm)term, (String)"preference", (int)5);
        }
        catch (ResultParserException e) {
            CommandException commandException = new CommandException(e.getLocalizedMessage(), e);
            commandException.notifyUserOnce();
            throw commandException;
        }
        return new ProBPreference(compoundTerm);
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        ListPrologTerm p = (ListPrologTerm)bindings.get((Object)PREFS_VARIABLE);
        this.prefs = new ArrayList<ProBPreference>();
        for (PrologTerm term : p) {
            ProBPreference preference = null;
            preference = this.verifyTerm(term);
            this.prefs.add(preference);
        }
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("list_eclipse_preferences").printVariable(PREFS_VARIABLE).closeTerm();
    }
}

