/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.List;

public class GetErrorsCommand
implements IComposableCommand {
    private static final String ERRORS_VARIABLE = "Errors";
    private static final String ONLY_WARNINGS_VARIABLE = "OnlyWarnings";
    private List<String> errors;
    private boolean onlyWarnings;

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        this.errors = PrologTerm.atomicStrings((Iterable)((ListPrologTerm)bindings.get((Object)ERRORS_VARIABLE)));
        this.onlyWarnings = "true".equals(((PrologTerm)bindings.get((Object)ONLY_WARNINGS_VARIABLE)).getFunctor());
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("getErrorMessages").printVariable(ONLY_WARNINGS_VARIABLE).printVariable(ERRORS_VARIABLE).closeTerm();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean onlyWarningsOccurred() {
        return this.onlyWarnings;
    }
}

