/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.output.PrologTermDelegate;
import de.prob.prolog.term.PrologTerm;
import java.util.List;

public class ComposedCommand
implements IComposableCommand {
    private static final char[] LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private final IComposableCommand[] cmds;

    public ComposedCommand(IComposableCommand ... cmds) {
        this.cmds = cmds;
    }

    public ComposedCommand(List<? extends IComposableCommand> cmds) {
        this.cmds = cmds.toArray(new IComposableCommand[0]);
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        PrefixMap<PrologTerm> prefixMap = new PrefixMap<PrologTerm>(bindings);
        int i = 0;
        while (i < this.cmds.length) {
            this.processPrefixedCommand(prefixMap, i);
            ++i;
        }
    }

    private void processPrefixedCommand(PrefixMap<PrologTerm> prefixMap, int i) throws CommandException {
        prefixMap.prefix = ComposedCommand.createPrefix(i);
        this.cmds[i].processResult(prefixMap);
    }

    @Override
    public void writeCommand(IPrologTermOutput orig) throws CommandException {
        PrologPrefixVarOutput pto = new PrologPrefixVarOutput(orig);
        int i = 0;
        while (i < this.cmds.length) {
            this.writePrefixedCommand(pto, i);
            ++i;
        }
    }

    private void writePrefixedCommand(PrologPrefixVarOutput pto, int i) throws CommandException {
        pto.prefix = ComposedCommand.createPrefix(i);
        this.cmds[i].writeCommand((IPrologTermOutput)pto);
    }

    private static String createPrefix(int i) {
        if (i < LETTERS.length) {
            return String.valueOf(LETTERS[i]);
        }
        int letternum = i % LETTERS.length;
        int number = i / LETTERS.length;
        return String.valueOf(LETTERS[letternum]) + number;
    }

    public void reprocessResult(IComposableCommand command, ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        int i = 0;
        while (i < this.cmds.length) {
            if (command.equals(this.cmds[i])) {
                PrefixMap<PrologTerm> prefixMap = new PrefixMap<PrologTerm>(bindings);
                this.processPrefixedCommand(prefixMap, i);
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("cannot reprocess command, command unknown");
    }

    private static final class PrefixMap<V>
    implements ISimplifiedROMap<String, V> {
        private final ISimplifiedROMap<String, V> map;
        private String prefix;

        public PrefixMap(ISimplifiedROMap<String, V> map) {
            this.map = map;
        }

        public V get(String key) {
            return (V)this.map.get(this.prefix == null ? key : this.prefix + key);
        }

        public String toString() {
            return this.map.toString();
        }
    }

    private static final class PrologPrefixVarOutput
    extends PrologTermDelegate {
        private String prefix;

        public PrologPrefixVarOutput(IPrologTermOutput pto) {
            super(pto);
        }

        public IPrologTermOutput printVariable(String var) {
            this.pto.printVariable((String)(this.prefix == null ? var : this.prefix + var));
            return this;
        }

        public IPrologTermOutput fullstop() {
            return this;
        }
    }
}

