/*
 * Decompiled with CFR 0.152.
 */
package de.prob.cli;

import de.prob.cli.CliException;
import de.prob.core.internal.Activator;
import de.prob.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.osgi.framework.Bundle;

public final class CliStarter {
    private static final Pattern CLI_PORT_PATTERN = Pattern.compile("^.*Port: (\\d+)$");
    private static final Pattern CLI_USER_INTERRUPT_REFERENCE_PATTERN = Pattern.compile("^.*user interrupt reference id: *(\\d+|off) *$");
    private Process prologProcess;
    private int port = -1;
    private long userInterruptReference = -1L;
    private OutputLoggerThread stdLogger;
    private OutputLoggerThread errLogger;

    public CliStarter() throws CliException {
        this(null);
    }

    public CliStarter(File file) throws CliException {
        this.startProlog(file);
    }

    public int getPort() {
        return this.port;
    }

    public void shutdown() {
        try {
            try {
                this.prologProcess.destroy();
            }
            catch (RuntimeException e) {
                String message = "XXXXX Error while stopping cli process: " + e.getLocalizedMessage();
                Logger.notifyUser(message, e);
                this.stdLogger.shutdown();
                this.errLogger.shutdown();
            }
        }
        finally {
            this.stdLogger.shutdown();
            this.errLogger.shutdown();
        }
    }

    private void setExecutable(File path, boolean executable) throws CliException {
        IFileStore store = EFS.getLocalFileSystem().getStore(path.toURI());
        IFileInfo info = store.fetchInfo();
        info.setAttribute(4, executable);
        try {
            store.putInfo(info, 1024, null);
        }
        catch (CoreException e) {
            throw new CliException("Failed to set executable permission", e, false);
        }
    }

    private static Optional<Integer> getProcessExitCode(Process process) {
        try {
            return Optional.of(process.exitValue());
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return Optional.empty();
        }
    }

    private void startProlog(File file) throws CliException {
        this.prologProcess = null;
        String os = Platform.getOS();
        File applicationPath = this.getCliPath();
        OsSpecificInfo osInfo = this.getOsInfo(os);
        String osPath = String.valueOf(applicationPath) + File.separator + osInfo.subdir;
        String executable = osPath + File.separator + osInfo.cliName;
        Logger.info("Starting ProB CLI for " + os + " ... Path is " + executable);
        if (osInfo.needsExecutePermission) {
            this.setExecutable(new File(executable), true);
        }
        ArrayList<String> command = new ArrayList<String>();
        if ("macosx".equals(os)) {
            command.add("arch");
            command.add("-64");
        }
        command.add(executable);
        command.add("-sf");
        command.add("-p");
        command.add("use_safety_ltl_model_checker");
        command.add("false");
        command.add("-prob_application_type");
        command.add("rodin");
        if (file != null) {
            command.add(file.getAbsolutePath());
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(command);
        pb.environment().put("NO_COLOR", "1");
        pb.environment().put("PROB_HOME", osPath);
        try {
            this.prologProcess = pb.start();
        }
        catch (IOException e) {
            throw new CliException("Problem while starting up ProB CLI. Tried to execute:" + executable, e, false);
        }
        Assert.isNotNull((Object)this.prologProcess);
        BufferedReader input = new BufferedReader(new InputStreamReader(this.prologProcess.getInputStream()));
        BufferedReader output = new BufferedReader(new InputStreamReader(this.prologProcess.getErrorStream()));
        this.startErrorLogger(output);
        try {
            this.extractCliInformation(input);
        }
        catch (CliException e) {
            Optional<Integer> exitCode = CliStarter.getProcessExitCode(this.prologProcess);
            if (exitCode.isPresent()) {
                throw new CliException("ProB CLI exited with status " + String.valueOf(exitCode.get()) + " before socket connection could be opened", e, false);
            }
            throw e;
        }
        this.startOutputLogger(input);
        final Process p = this.prologProcess;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                p.destroy();
            }
        }));
    }

    private OsSpecificInfo getOsInfo(String os) throws CliException {
        String subdir;
        if (os.equals("win32")) {
            return new OsSpecificInfo("windows64", "probcli.exe", "lib\\send_user_interrupt.exe", false);
        }
        if (os.equals("macosx")) {
            subdir = "macos";
        } else if (os.equals("linux")) {
            subdir = "linux64";
        } else {
            throw new CliException("ProB does not support the plattform: " + os);
        }
        return new OsSpecificInfo(subdir, "probcli.sh", "lib/send_user_interrupt", true);
    }

    private void extractCliInformation(BufferedReader input) throws CliException {
        Integer portTemp = null;
        Long userInterruptReferenceTemp = null;
        try {
            String line;
            while ((line = input.readLine()) != null) {
                Matcher userInterruptReferenceMatcher;
                Logger.info("probcli startup output: " + line);
                Matcher portMatcher = CLI_PORT_PATTERN.matcher(line);
                if (portMatcher.matches()) {
                    portTemp = Integer.parseInt(portMatcher.group(1));
                }
                if ((userInterruptReferenceMatcher = CLI_USER_INTERRUPT_REFERENCE_PATTERN.matcher(line)).matches()) {
                    String userInterruptReferenceString = userInterruptReferenceMatcher.group(1);
                    if ("off".equals(userInterruptReferenceString)) {
                        userInterruptReferenceTemp = -1L;
                        Logger.info("This ProB build has user interrupt support disabled. Interrupting ProB may not work as expected.");
                    } else {
                        userInterruptReferenceTemp = Long.parseLong(userInterruptReferenceString);
                    }
                }
                if (!(portTemp != null && userInterruptReferenceTemp != null || line.contains("starting command loop"))) {
                    continue;
                }
                break;
            }
        }
        catch (IOException | NumberFormatException e) {
            throw new CliException("Error while reading information from CLI", e, false);
        }
        if (portTemp == null) {
            throw new CliException("Did not receive port number from CLI");
        }
        if (userInterruptReferenceTemp == null) {
            throw new CliException("Did not receive user interrupt reference from CLI");
        }
        this.port = portTemp;
        this.userInterruptReference = userInterruptReferenceTemp;
    }

    private void startOutputLogger(BufferedReader input) {
        this.stdLogger = new OutputLoggerThread("(Output " + this.port + ")", input, false);
        this.stdLogger.start();
    }

    private void startErrorLogger(BufferedReader output) {
        this.errLogger = new OutputLoggerThread("(Error " + this.port + ")", output, true);
        this.errLogger.start();
    }

    private File getCliPath() throws CliException {
        URL fileUrl;
        Bundle bundle = Activator.getDefault().getBundle();
        URL entry = bundle.getEntry("prob");
        if (entry == null) {
            throw new CliException("Unable to find directory with prob executables.");
        }
        try {
            fileUrl = FileLocator.toFileURL((URL)entry);
        }
        catch (IOException e) {
            throw new CliException("Input/output error when trying to find '" + String.valueOf(entry) + "'", e, false);
        }
        try {
            return new File(URIUtil.toURI((URL)fileUrl));
        }
        catch (URISyntaxException e) {
            throw new CliException("Unable to construct file '" + entry.getPath() + "'", e, false);
        }
    }

    public void sendUserInterruptReference() {
        if (this.userInterruptReference != -1L) {
            try {
                OsSpecificInfo osInfo = this.getOsInfo(Platform.getOS());
                String command = String.valueOf(this.getCliPath()) + File.separator + osInfo.subdir + File.separator + osInfo.userInterruptCmd;
                if (osInfo.needsExecutePermission) {
                    this.setExecutable(new File(command), true);
                }
                Runtime.getRuntime().exec(new String[]{command, String.valueOf(this.userInterruptReference)});
            }
            catch (CliException e) {
                Logger.info("getting the os specific info failed with exception: " + e.getLocalizedMessage());
            }
            catch (IOException e) {
                Logger.info("calling the send_user_interrupt command failed: " + e.getLocalizedMessage());
            }
        }
    }

    private static class OsSpecificInfo {
        final String subdir;
        final String cliName;
        final String userInterruptCmd;
        final boolean needsExecutePermission;

        public OsSpecificInfo(String subdir, String cliName, String userInterruptCmd, boolean needsExecutePermission) {
            this.subdir = subdir;
            this.cliName = cliName;
            this.userInterruptCmd = userInterruptCmd;
            this.needsExecutePermission = needsExecutePermission;
        }
    }

    private static class OutputLoggerThread
    extends Thread {
        private final BufferedReader in;
        private final String prefix;
        private final boolean logToLog;
        private volatile boolean shutingDown = false;

        public OutputLoggerThread(String name, BufferedReader in, boolean logToLog) {
            this.prefix = "[" + name + "] ";
            this.in = in;
            this.logToLog = logToLog;
        }

        @Override
        public void run() {
            block18: {
                try {
                    try {
                        while (!this.shutingDown) {
                            String line = this.in.readLine();
                            if (line != null) {
                                if (this.logToLog) {
                                    Logger.log(1, this.prefix + line, null);
                                }
                                System.err.println(this.prefix + line);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (IOException e) {
                        if (!"Stream closed".equals(e.getMessage())) {
                            Logger.log(1, "OutputLogger died with error", e);
                        }
                        if (this.in != null) {
                            try {
                                this.in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (this.in != null) {
                        try {
                            this.in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        public void shutdown() {
            this.shutingDown = true;
            if (this.isAlive()) {
                this.interrupt();
            }
        }
    }
}

