/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.scheduler;

import de.bmotionstudio.gef.editor.Animation;
import de.bmotionstudio.gef.editor.BindingObject;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.scheduler.ExecuteOperationByPredicate;
import de.bmotionstudio.gef.editor.scheduler.PredicateOperation;
import de.bmotionstudio.gef.editor.scheduler.SchedulerEvent;
import de.bmotionstudio.gef.editor.scheduler.SchedulerWizard;
import de.bmotionstudio.gef.editor.scheduler.wizard.WizardExecuteOperationByPredicateMulti;
import de.bmotionstudio.gef.editor.util.BMSUtil;
import java.util.ArrayList;

public class ExecuteOperationByPredicateMulti
extends SchedulerEvent {
    public static String ID = "de.bmotionstudio.gef.editor.scheduler.ExecuteOperationByPredicateMulti";
    private ArrayList<BindingObject> operationList = new ArrayList();

    @Override
    public void execute(Animation animation, BControl control) {
        for (BindingObject op : this.operationList) {
            String bolValue = "true";
            String executePredicate = ((PredicateOperation)op).getExecutePredicate();
            if (executePredicate != null && executePredicate.length() > 0) {
                bolValue = BMSUtil.parsePredicate(executePredicate, control, animation);
            }
            if (!Boolean.valueOf(bolValue).booleanValue()) continue;
            this.executeOperation(animation, (PredicateOperation)op, control);
            break;
        }
    }

    private void executeOperation(Animation animation, PredicateOperation predicateOperation, BControl control) {
        ExecuteOperationByPredicate executeCmd = new ExecuteOperationByPredicate();
        executeCmd.setPredicateOperation(predicateOperation);
        executeCmd.execute(animation, control);
    }

    @Override
    public SchedulerWizard getWizard(BControl bcontrol) {
        return new WizardExecuteOperationByPredicateMulti(bcontrol, this);
    }

    public void setOperationList(ArrayList<BindingObject> operationList) {
        this.operationList = operationList;
    }

    public ArrayList<BindingObject> getOperationList() {
        if (this.operationList == null) {
            this.operationList = new ArrayList();
        }
        return this.operationList;
    }

    @Override
    public ExecuteOperationByPredicateMulti clone() throws CloneNotSupportedException {
        ExecuteOperationByPredicateMulti nse = (ExecuteOperationByPredicateMulti)super.clone();
        ArrayList<BindingObject> opList = new ArrayList<BindingObject>();
        for (BindingObject p : this.getOperationList()) {
            opList.add(((PredicateOperation)p).clone());
        }
        nse.setOperationList(opList);
        return nse;
    }
}

