/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.part;

import de.bmotionstudio.gef.editor.attribute.AbstractAttribute;
import de.bmotionstudio.gef.editor.figure.AbstractBMotionFigure;
import de.bmotionstudio.gef.editor.library.AbstractLibraryCommand;
import de.bmotionstudio.gef.editor.library.AttributeRequest;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.model.Visualization;
import de.bmotionstudio.gef.editor.observer.IObserverListener;
import de.bmotionstudio.gef.editor.observer.Observer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class BMSAbstractEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
IObserverListener,
IAdaptable,
NodeEditPart {
    private final Cursor cursorHover = new Cursor((Device)Display.getCurrent(), 21);
    protected ConnectionAnchor anchor;
    private ChangeListener changeListener = new ChangeListener(){

        public void handleStateChanged(ChangeEvent event) {
            AbstractBMotionFigure f;
            if (BMSAbstractEditPart.this.getCastedModel().hasEvent("de.bmotionstudio.gef.editor.event.OnClickEvent").booleanValue() && event.getPropertyName().equals("mouseover")) {
                BMSAbstractEditPart.this.getFigure().setCursor(BMSAbstractEditPart.this.cursorHover);
            }
            if (event.getPropertyName().equals("pressed") && (f = (AbstractBMotionFigure)BMSAbstractEditPart.this.getFigure()).getModel().isPressed()) {
                BMSAbstractEditPart.this.executeEvent("de.bmotionstudio.gef.editor.event.OnClickEvent");
            }
        }
    };
    private String[] layoutAttributes = new String[]{"ControlLayout", "ControlLocation", "de.bmotionstudio.gef.editor.attribute.BAttributeX", "de.bmotionstudio.gef.editor.attribute.BAttributeY", "de.bmotionstudio.gef.editor.attribute.BAttributeWidth", "de.bmotionstudio.gef.editor.attribute.BAttributeHeight"};

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((BControl)this.getModel()).addPropertyChangeListener(this);
            if (this.getFigure() instanceof AbstractBMotionFigure) {
                AbstractBMotionFigure af = (AbstractBMotionFigure)this.getFigure();
                if (this.isRunning().booleanValue()) {
                    af.addChangeListener(this.changeListener);
                }
                af.activateFigure();
            }
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((BControl)this.getModel()).removePropertyChangeListener(this);
            if (this.getFigure() instanceof AbstractBMotionFigure) {
                AbstractBMotionFigure af = (AbstractBMotionFigure)this.getFigure();
                if (this.isRunning().booleanValue()) {
                    af.removeChangeListener(this.changeListener);
                }
                af.deactivateFigure();
            }
        }
    }

    protected abstract IFigure createEditFigure();

    protected void createEditPolicies() {
        if (this.isRunning().booleanValue()) {
            this.prepareRunPolicies();
        } else {
            this.prepareEditPolicies();
        }
    }

    protected abstract void prepareEditPolicies();

    protected abstract void prepareRunPolicies();

    protected Boolean isRunning() {
        return ((BControl)this.getModel()).getVisualization().isRunning();
    }

    protected IFigure createFigure() {
        IFigure figure = this.createEditFigure();
        IFigure toolTipFigure = this.getToolTip();
        if (toolTipFigure != null) {
            figure.setToolTip(toolTipFigure);
        }
        if (figure instanceof AbstractBMotionFigure) {
            AbstractBMotionFigure bmsFigure = (AbstractBMotionFigure)figure;
            Boolean isRunning = this.isRunning();
            bmsFigure.setRunning(isRunning);
            if (!isRunning.booleanValue()) {
                bmsFigure.setEnabled(false);
            }
        }
        return figure;
    }

    public void performRequest(Request req) {
        if (!this.isRunning().booleanValue() && req.getType().equals("open")) {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    protected void refreshVisuals() {
        IFigure figure = this.getFigure();
        BControl model = (BControl)this.getModel();
        for (Map.Entry<String, AbstractAttribute> e : model.getAttributes().entrySet()) {
            PropertyChangeEvent evt = new PropertyChangeEvent(model, e.getKey(), null, e.getValue().getValue());
            this.refreshEditFigure(figure, model, evt);
        }
        this.refreshEditLayout(figure, model);
    }

    public abstract void refreshEditFigure(IFigure var1, BControl var2, PropertyChangeEvent var3);

    protected void refreshEditLayout(IFigure figure, BControl control) {
        if (!(control instanceof Visualization)) {
            figure.setPreferredSize(control.getDimension());
            if (figure.getParent() != null) {
                figure.getParent().setConstraint(figure, (Object)new Rectangle(control.getLayout()));
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        IFigure figure = this.getFigure();
        BControl model = (BControl)this.getModel();
        String propName = evt.getPropertyName();
        if ("ControlSourceConn".equals(propName)) {
            this.refreshSourceConnections();
        } else if ("ControlTargetConn".equals(propName)) {
            this.refreshTargetConnections();
        }
        if (propName.equals("ControlAddChild") || propName.equals("ControlRemoveChild")) {
            this.refreshChildren();
        } else if (Arrays.asList(this.layoutAttributes).contains(propName)) {
            if (this.isRunning().booleanValue()) {
                this.refreshEditLayout(figure, model);
            } else {
                this.refreshEditLayout(figure, model);
            }
        } else if (this.isRunning().booleanValue()) {
            this.refreshEditFigure(figure, model, evt);
        } else {
            this.refreshEditFigure(figure, model, evt);
        }
    }

    public List<BControl> getModelChildren() {
        return new ArrayList<BControl>();
    }

    public void executeEvent(String event) {
        this.getCastedModel().executeEvent(event);
    }

    protected IFigure getToolTip() {
        Figure fig = new Figure();
        fig.setLayoutManager((LayoutManager)new FlowLayout());
        Collection<Observer> observerList = ((BControl)this.getModel()).getObservers().values();
        for (Observer observer : observerList) {
            IFigure observerFigure = observer.getToolTip((BControl)this.getModel());
            if (observerFigure == null) continue;
            fig.add(observerFigure);
        }
        return fig;
    }

    @Override
    public void addedObserver(BControl control, Observer observer) {
        this.getFigure().setToolTip(this.getToolTip());
    }

    @Override
    public void removedObserver(BControl control) {
    }

    public AbstractLibraryCommand getLibraryCommand(AttributeRequest request) {
        return null;
    }

    protected BControl getCastedModel() {
        return (BControl)this.getModel();
    }

    protected ConnectionAnchor getConnectionAnchor() {
        if (this.anchor == null) {
            this.anchor = new ChopboxAnchor(this.getFigure());
        }
        return this.anchor;
    }

    protected List<?> getModelSourceConnections() {
        return this.getCastedModel().getSourceConnections();
    }

    protected List<?> getModelTargetConnections() {
        return this.getCastedModel().getTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }
}

