/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.part;

import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.editpolicy.BMSDeletePolicy;
import de.bmotionstudio.gef.editor.model.BConnection;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.model.Visualization;
import de.bmotionstudio.gef.editor.observer.IObserverListener;
import de.bmotionstudio.gef.editor.observer.Observer;
import de.bmotionstudio.gef.editor.part.BMSAbstractTreeEditPart;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class BControlTreeEditPart
extends BMSAbstractTreeEditPart
implements PropertyChangeListener,
IObserverListener {
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("ControlAddChild") || evt.getPropertyName().equals("ControlRemoveChild")) {
            this.refreshChildren();
        }
        this.refreshVisuals();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new BMSDeletePolicy());
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> toShowElements = new ArrayList<Object>();
        if (this.getModel() instanceof BControl) {
            BControl c = (BControl)this.getModel();
            for (BControl control : c.getChildrenArray()) {
                if (control.showInOutlineView()) {
                    toShowElements.add(control);
                }
                List<BConnection> sourceConnections = control.getSourceConnections();
                for (BConnection con : sourceConnections) {
                    if (!con.showInOutlineView() || toShowElements.contains(con)) continue;
                    toShowElements.add(con);
                }
                List<BConnection> targetConnections = control.getTargetConnections();
                for (BConnection con : targetConnections) {
                    if (!con.showInOutlineView() || toShowElements.contains(con)) continue;
                    toShowElements.add(con);
                }
            }
        }
        return toShowElements;
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((BControl)this.getModel()).addPropertyChangeListener(this);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((BControl)this.getModel()).removePropertyChangeListener(this);
        }
    }

    public void refreshVisuals() {
        Object model = this.getModel();
        if (model instanceof BControl) {
            BControl bcontrol = (BControl)model;
            if (!(bcontrol instanceof Visualization)) {
                this.setWidgetText(bcontrol.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeID").toString());
                this.setWidgetImage(bcontrol.getIcon());
            }
        } else if (model instanceof Observer) {
            this.setWidgetText(((Observer)model).getName());
            this.setWidgetImage(BMotionStudioImage.getImage("icon_observer"));
        }
    }

    public void performRequest(Request req) {
        if (req.getType().equals("open")) {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addedObserver(BControl control, Observer observer) {
        this.refreshChildren();
    }

    @Override
    public void removedObserver(BControl control) {
        this.refreshChildren();
    }
}

