/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.observer.wizard;

import de.bmotionstudio.gef.editor.observer.ObserverEvalObject;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class WizardObserverDropListener
extends ViewerDropAdapter {
    private String observerName;

    public WizardObserverDropListener(Viewer viewer, String observerName) {
        super(viewer);
        this.observerName = observerName;
    }

    public void drop(DropTargetEvent event) {
        Object[] sourceSetAttributeObjects = (Object[])event.data;
        Object targetSetAttributeObject = this.determineTarget(event);
        Object input = this.getViewer().getInput();
        if (input instanceof WritableList) {
            WritableList list = (WritableList)input;
            Object[] objectArray = sourceSetAttributeObjects;
            int n = sourceSetAttributeObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object sourceObject = objectArray[n2];
                if (sourceObject instanceof ObserverEvalObject) {
                    ObserverEvalObject sourceEvalObject = (ObserverEvalObject)sourceObject;
                    if (sourceObject.getClass().equals(list.getElementType())) {
                        int indexOf = list.indexOf(targetSetAttributeObject);
                        if (indexOf == -1) {
                            indexOf = 0;
                        }
                        ObserverEvalObject newElement = sourceEvalObject;
                        if (!list.remove((Object)sourceEvalObject)) {
                            try {
                                newElement = sourceEvalObject.clone();
                            }
                            catch (CloneNotSupportedException e) {
                                e.printStackTrace();
                            }
                        }
                        list.add(indexOf, (Object)newElement);
                    } else {
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Drag and Drop is not supported", (String)("It is not possible to add an item of the type " + String.valueOf(sourceEvalObject.getClass()) + " to the observer \"" + this.observerName + "\"."));
                    }
                }
                ++n2;
            }
        }
        super.drop(event);
    }

    public boolean performDrop(Object data) {
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return true;
    }
}

