/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.observer;

import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.bmotionstudio.gef.editor.Animation;
import de.bmotionstudio.gef.editor.attribute.AbstractAttribute;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.observer.Observer;
import de.bmotionstudio.gef.editor.observer.ObserverWizard;
import de.bmotionstudio.gef.editor.observer.wizard.WizardObserverListenOperationByPredicate;
import de.bmotionstudio.gef.editor.scheduler.PredicateOperation;
import de.bmotionstudio.gef.editor.util.BMSUtil;
import de.prob.core.Animator;
import de.prob.core.command.GetOperationByPredicateCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.exceptions.ProBException;
import java.util.ArrayList;
import java.util.List;

public class ListenOperationByPredicate
extends Observer {
    public static String ID = "de.bmotionstudio.gef.editor.observer.ListenOperationByPredicate";
    private ArrayList<PredicateOperation> list = new ArrayList();
    private transient List<String> setAttributes = new ArrayList<String>();

    public ListenOperationByPredicate() {
        this(new ArrayList<PredicateOperation>());
    }

    public ListenOperationByPredicate(ArrayList<PredicateOperation> list) {
        this.list = list;
    }

    @Override
    protected Object readResolve() {
        this.setAttributes = new ArrayList<String>();
        return super.readResolve();
    }

    @Override
    public void check(Animation animation, BControl control) {
        this.setAttributes.clear();
        State state = animation.getState();
        Animator animator = animation.getAnimator();
        for (PredicateOperation pop : this.getList()) {
            if (pop.getAttribute() == null) {
                pop.setAttribute("de.bmotionstudio.gef.editor.attribute.BAttributeEnabled");
            }
            if (pop.getValue() == null) {
                pop.setValue(true);
            }
            String fPredicate = pop.getPredicate();
            String fOpName = pop.getOperationName();
            if (fOpName == null || fPredicate == null || !animation.getCurrentStateOperations().containsKey(fOpName)) continue;
            if (fPredicate.length() > 0) {
                fPredicate = BMSUtil.parseControls(fPredicate, control);
            }
            try {
                Object oldAttrVal;
                Operation operation;
                if (fPredicate.equals("")) {
                    fPredicate = "1=1";
                }
                if ((operation = GetOperationByPredicateCommand.getOperation((Animator)animator, (String)state.getId(), (String)fOpName, (String)fPredicate)) == null) continue;
                String attributeID = pop.getAttribute();
                AbstractAttribute attributeObj = control.getAttribute(attributeID);
                Object attributeVal = pop.getValue();
                if (pop.isExpressionMode().booleanValue()) {
                    String strAtrVal = BMSUtil.parseExpression(attributeVal.toString(), control, animation);
                    String er = attributeObj.validateValue(strAtrVal, null);
                    if (er != null) {
                        pop.setHasError(true);
                    } else {
                        attributeVal = attributeObj.unmarshal(strAtrVal);
                    }
                }
                if (!pop.hasError().booleanValue() && !(oldAttrVal = control.getAttributeValue(attributeID)).equals(attributeVal)) {
                    control.setAttributeValue(attributeID, attributeVal, true, false);
                }
                this.setAttributes.add(attributeID);
            }
            catch (ProBException proBException) {
            }
            catch (BCompoundException bCompoundException) {}
        }
        for (PredicateOperation obj : this.list) {
            if (this.setAttributes.contains(obj.getAttribute())) continue;
            AbstractAttribute attributeObj = control.getAttribute(obj.getAttribute());
            Object oldAttrVal = control.getAttributeValue(obj.getAttribute());
            if (oldAttrVal.equals(attributeObj.getInitValue())) continue;
            control.restoreDefaultValue(attributeObj.getID());
        }
    }

    @Override
    public ObserverWizard getWizard(BControl control) {
        return new WizardObserverListenOperationByPredicate(control, this);
    }

    public void setList(ArrayList<PredicateOperation> list) {
        this.list = list;
    }

    public ArrayList<PredicateOperation> getList() {
        if (this.list == null) {
            this.list = new ArrayList();
        }
        return this.list;
    }

    public void addPredicateOperation(PredicateOperation predicateOperation) {
        this.getList().add(predicateOperation);
    }

    public void removePredicateOperation(PredicateOperation predicateOperation) {
        this.getList().remove(predicateOperation);
    }

    @Override
    public Observer clone() throws CloneNotSupportedException {
        ListenOperationByPredicate clone = (ListenOperationByPredicate)super.clone();
        ArrayList<PredicateOperation> clonedList = new ArrayList<PredicateOperation>();
        for (PredicateOperation pop : this.getList()) {
            clonedList.add(pop.clone());
        }
        clone.setList(clonedList);
        return clone;
    }
}

