/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.observer;

import de.bmotionstudio.gef.editor.Animation;
import de.bmotionstudio.gef.editor.attribute.AbstractAttribute;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.observer.Observer;
import de.bmotionstudio.gef.editor.observer.ObserverWizard;
import de.bmotionstudio.gef.editor.observer.wizard.WizardColumnObserver;
import de.bmotionstudio.gef.editor.util.BMSUtil;
import de.prob.unicode.UnicodeTranslator;
import java.util.LinkedList;
import java.util.List;

public class ColumnObserver
extends Observer {
    private String expression;
    private String predicate;

    public static List<String> split(String input, char tempReplacement) {
        while (input.matches(".*\"[^\\{\\}]+,[^\\{\\}]+.*")) {
            input = input.replaceAll("(\"[^\\{\\}]+),([^\\{\\}]+)", "$1" + tempReplacement + "$2");
        }
        while (input.matches(".*\\{[^\\}]+,[^\\}]+\\}.*")) {
            input = input.replaceAll("(\\{[^\\}]+),([^\\}]+\\})", "$1" + tempReplacement + "$2");
        }
        String[] split = input.split(",");
        LinkedList<String> output = new LinkedList<String>();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            output.add(s.replaceAll("" + tempReplacement, ",").trim());
            ++n2;
        }
        return output;
    }

    @Override
    public void check(Animation animation, BControl control) {
        String bolValue = "true";
        if (this.predicate != null && this.predicate.length() > 0) {
            bolValue = BMSUtil.parsePredicate(this.predicate, control, animation);
        }
        if (Boolean.valueOf(bolValue).booleanValue()) {
            String fEval = BMSUtil.parseExpression(this.expression, control, animation);
            fEval = UnicodeTranslator.toAscii((String)fEval);
            fEval = fEval.replaceAll("^\\{", "");
            fEval = fEval.replaceAll("\\}$", "");
            List<String> output = ColumnObserver.split(fEval, '#');
            AbstractAttribute attributeRows = control.getParent().getAttribute("de.bmotionstudio.gef.editor.attribute.BAttributeRows");
            Integer defaultRows = Integer.valueOf(attributeRows.getInitValue().toString());
            control.getParent().setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeRows", defaultRows + output.size(), true, false);
            int i = defaultRows;
            while (i < output.size() + defaultRows) {
                String val = output.get(i - defaultRows);
                if (val != null && val.length() > 0) {
                    val = UnicodeTranslator.toUnicode((String)val);
                }
                control.getChildrenArray().get(i).setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeText", val);
                ++i;
            }
        }
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    @Override
    public ObserverWizard getWizard(BControl control) {
        return new WizardColumnObserver(control, this);
    }
}

