/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.model;

import de.bmotionstudio.gef.editor.Animation;
import de.bmotionstudio.gef.editor.ButtonGroupHelper;
import de.bmotionstudio.gef.editor.model.BConnection;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.model.BMotionRuler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;

public class Visualization
extends BControl {
    public static transient String TYPE = "de.bmotionstudio.gef.editor.visualization";
    protected String bmachine;
    protected String language;
    protected String version;
    protected BMotionRuler leftRuler;
    protected BMotionRuler topRuler;
    private boolean rulersVisibility;
    private boolean snapToGeometry;
    private boolean gridEnabled;
    private transient List<String> allBControlIDs;
    private transient Boolean isRunning;
    private transient Animation animation;
    private transient IFile projectFile;

    public List<String> getAllBControlIDs() {
        if (this.allBControlIDs == null) {
            this.allBControlIDs = this.getAllBControlNames();
        }
        return this.allBControlIDs;
    }

    public Visualization(String bmachine, String language, String version) {
        super(null);
        this.setVisualization(this);
        this.rulersVisibility = true;
        this.bmachine = bmachine;
        this.language = language;
        this.version = version;
        this.isRunning = false;
        this.snapToGeometry = true;
        this.createRulers();
        ButtonGroupHelper.reset();
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.isRunning = false;
        this.createRulers();
        ButtonGroupHelper.reset();
        this.setVisualization(this);
        this.init();
        this.initChildren(this.getChildrenArray());
        return this;
    }

    private void initChildren(List<BControl> children) {
        for (BControl c : children) {
            c.setVisualization(this);
            c.init();
            for (BConnection sc : c.getSourceConnections()) {
                sc.setVisualization(this);
                sc.init();
            }
            for (BConnection tc : c.getTargetConnections()) {
                tc.setVisualization(this);
                tc.init();
            }
            this.initChildren(c.getChildrenArray());
        }
    }

    public void setIsRunning(Boolean bol) {
        this.isRunning = bol;
    }

    public Boolean isRunning() {
        return this.isRunning;
    }

    public IFile getProjectFile() {
        return this.projectFile;
    }

    public void setProjectFile(IFile pf) {
        this.projectFile = pf;
    }

    public String getMachineName() {
        return this.bmachine;
    }

    public void setMachineName(String machineName) {
        this.bmachine = machineName;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public List<String> getAllBControlNames() {
        return this.getAllBControlNames(this.getChildrenArray());
    }

    private List<String> getAllBControlNames(List<BControl> children) {
        ArrayList<String> list = new ArrayList<String>();
        for (BControl control : children) {
            list.add(control.getID());
            List<BControl> subchildren = control.getChildrenArray();
            if (children.size() > 0) {
                list.addAll(this.getAllBControlNames(subchildren));
            }
            ArrayList<BControl> connections = new ArrayList<BControl>();
            connections.addAll(control.getSourceConnections());
            connections.addAll(control.getTargetConnections());
            if (connections.size() <= 0) continue;
            list.addAll(this.getAllBControlNames(connections));
        }
        return list;
    }

    public String getMaxIDString(String type) {
        String newID = this.getMaxID(type, 0, this.getAllBControlIDs());
        this.getAllBControlIDs().add(newID);
        return newID;
    }

    private String getMaxID(String type, int count, List<String> allIDs) {
        String newID = "control_" + count;
        if (allIDs.contains(newID)) {
            return this.getMaxID(type, count + 1, allIDs);
        }
        return newID;
    }

    public boolean checkIfIdExists(String ID) {
        return this.getAllBControlNames().contains(ID);
    }

    public BControl getBControl(String ID) {
        return this.getBControl(ID, this.getChildrenArray());
    }

    private BControl getBControl(String ID, List<BControl> children) {
        for (BControl control : children) {
            BControl childControl;
            if (control.getID().equals(ID)) {
                return control;
            }
            for (BConnection c : control.getSourceConnections()) {
                if (!c.getID().equals(ID)) continue;
                return c;
            }
            for (BConnection c : control.getTargetConnections()) {
                if (!c.getID().equals(ID)) continue;
                return c;
            }
            if (control.getChildrenArray().size() <= 0 || (childControl = this.getBControl(ID, control.getChildrenArray())) == null) continue;
            return childControl;
        }
        return null;
    }

    public BMotionRuler getRuler(int orientation) {
        BMotionRuler result = null;
        switch (orientation) {
            case 1: {
                result = this.topRuler;
                break;
            }
            case 8: {
                result = this.leftRuler;
            }
        }
        return result;
    }

    public BMotionRuler getTopRuler() {
        return this.topRuler;
    }

    public void setTopRuler(BMotionRuler topRuler) {
        this.topRuler = topRuler;
    }

    public BMotionRuler getLeftRuler() {
        return this.leftRuler;
    }

    public void setLeftRuler(BMotionRuler leftRuler) {
        this.leftRuler = leftRuler;
    }

    protected void createRulers() {
        if (this.leftRuler == null) {
            this.leftRuler = new BMotionRuler(false);
        }
        if (this.topRuler == null) {
            this.topRuler = new BMotionRuler(true);
        }
    }

    public void setRulerVisibility(boolean newValue) {
        this.rulersVisibility = newValue;
    }

    public void setGridEnabled(boolean isEnabled) {
        this.gridEnabled = isEnabled;
    }

    public void setSnapToGeometry(boolean isEnabled) {
        this.snapToGeometry = isEnabled;
    }

    public boolean getRulerVisibility() {
        return this.rulersVisibility;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public boolean isSnapToGeometryEnabled() {
        return this.snapToGeometry;
    }

    @Override
    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected void initAttributes() {
    }

    @Override
    public boolean canHaveChildren() {
        return true;
    }

    @Override
    public Visualization getVisualization() {
        return this;
    }
}

