/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.internal;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import de.bmotionstudio.gef.editor.Animation;
import de.bmotionstudio.gef.editor.BMotionEditorPlugin;
import de.bmotionstudio.gef.editor.BMotionStudioEditor;
import de.bmotionstudio.gef.editor.ILanguageService;
import de.bmotionstudio.gef.editor.internal.ProgressBarDialog;
import de.bmotionstudio.gef.editor.internal.SelectOperationDialog;
import de.bmotionstudio.gef.editor.model.Visualization;
import de.prob.core.Animator;
import de.prob.core.command.ExecuteOperationCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.exceptions.ProBException;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

public class VisualizationProgressBar
extends ProgressBarDialog {
    private Animator animator;
    private IFile f;
    private Visualization visualization;
    private Animation animation;
    private int confirm = -1;
    private SelectOperationDialog dialog;
    private BMotionStudioEditor activeEditor;

    public VisualizationProgressBar(Shell parent, Animator animator, BMotionStudioEditor activeEditor, IFile f) {
        super(parent);
        this.animator = animator;
        this.activeEditor = activeEditor;
        this.f = f;
    }

    @Override
    public void initGuage() {
        this.setExecuteTime(6);
        this.setMayCancel(true);
        this.setProcessMessage("Starting Visualization ...");
        this.setShellTitle("Starting Visualization");
    }

    @Override
    protected String process(int i) {
        switch (i) {
            case 1: {
                try {
                    this.createVisualizationRoot();
                }
                catch (CoreException e) {
                    this.openErrorDialog(e.getMessage());
                    this.setClose(true);
                }
                catch (IOException e) {
                    this.openErrorDialog(e.getMessage());
                    this.setClose(true);
                }
                catch (ParserConfigurationException e) {
                    this.openErrorDialog(e.getMessage());
                    this.setClose(true);
                }
                catch (SAXException e) {
                    this.openErrorDialog(e.getMessage());
                    this.setClose(true);
                }
                return "Starting ProB Animator";
            }
            case 2: {
                this.startProbAnimator();
                return "Setup Constants";
            }
            case 3: {
                try {
                    this.setupOperation("SETUP_CONTEXT");
                }
                catch (InterruptedException e) {
                    this.openErrorDialog(e.getMessage());
                    this.setClose(true);
                }
                return "Create Visualization";
            }
            case 4: {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        VisualizationProgressBar.this.createShell();
                    }
                });
                return "Initialize machine";
            }
            case 5: {
                try {
                    this.setupOperation("INITIALISATION");
                }
                catch (InterruptedException e) {
                    this.openErrorDialog(e.getMessage());
                    this.setClose(true);
                }
                return "Starting Visualization";
            }
        }
        return "Starting BMotion Studio Visualization";
    }

    private void createVisualizationRoot() throws CoreException, IOException, ParserConfigurationException, SAXException {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver()){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper((Mapper)next){

                    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                        if (definedIn == Object.class) {
                            return false;
                        }
                        return super.shouldSerializeMember(definedIn, fieldName);
                    }
                };
            }
        };
        BMotionEditorPlugin.setAliases(xstream);
        this.visualization = (Visualization)xstream.fromXML(this.f.getContents());
        this.visualization.setProjectFile(this.f);
    }

    @Override
    protected void cleanUp() {
        if (this.animation != null) {
            this.animation.unregister();
        }
    }

    private void startProbAnimator() {
        this.animation = new Animation(this.animator, this.visualization);
        ILanguageService langService = this.getGenericLoadMachine(this.visualization.getLanguage());
        if (langService != null) {
            try {
                langService.startProBAnimator(this.visualization);
            }
            catch (ProBException e) {
                this.openErrorDialog(e.getMessage());
                this.setClose(true);
            }
        } else {
            this.openErrorDialog("Unknown formal language: " + this.visualization.getLanguage());
            this.setClose(true);
        }
    }

    private void setupOperation(String opName) throws InterruptedException {
        block11: {
            final List ops = this.animation.getState().getEnabledOperations();
            if (ops.size() > 1) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        VisualizationProgressBar.this.dialog = new SelectOperationDialog(VisualizationProgressBar.this.getShell(), ops);
                        VisualizationProgressBar.this.confirm = VisualizationProgressBar.this.dialog.open();
                    }
                });
                do {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        this.openErrorDialog(e.getMessage());
                        this.setClose(true);
                    }
                    if (this.confirm != 0) continue;
                    Operation op = this.dialog.getSelectedOperation();
                    if (op != null) {
                        try {
                            ExecuteOperationCommand.executeOperation((Animator)this.animator, (Operation)op);
                        }
                        catch (ProBException e) {
                            this.openErrorDialog(e.getMessage());
                            this.setClose(true);
                        }
                    }
                    this.confirm = -1;
                    break block11;
                } while (this.confirm != 1);
                this.setClose(true);
                this.confirm = -1;
            } else {
                Operation op = this.animation.getCurrentStateOperation(opName);
                if (op != null) {
                    try {
                        ExecuteOperationCommand.executeOperation((Animator)this.animator, (Operation)op);
                    }
                    catch (ProBException e) {
                        this.openErrorDialog(e.getMessage());
                        this.setClose(true);
                    }
                }
            }
        }
        this.visualization.setIsRunning(true);
    }

    private void createShell() {
        this.activeEditor.createRunPage(this.visualization, this.animation);
    }

    private ILanguageService getGenericLoadMachine(String language) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("de.bmotionstudio.gef.editor.language");
        ILanguageService langService = null;
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if ("language".equals(configurationElement.getName())) {
                    String languageEx = configurationElement.getAttribute("id");
                    if (language.toLowerCase(Locale.ENGLISH).equals(languageEx.toLowerCase(Locale.ENGLISH))) {
                        try {
                            langService = (ILanguageService)configurationElement.createExecutableExtension("service");
                        }
                        catch (CoreException e) {
                            this.openErrorDialog(e.getMessage());
                            this.setClose(true);
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return langService;
    }

    public void kill() {
    }

    public void openErrorDialog(final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)VisualizationProgressBar.this.getParent(), (String)"Error", (String)"Error creating visualization", (IStatus)new Status(4, "de.bmotionstudio.gef.editor", msg));
            }
        });
    }
}

