/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.internal;

import de.bmotionstudio.gef.editor.BMotionStudioImage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public abstract class ProgressBarDialog
extends Dialog {
    private Label processMessageLabel;
    private Button cancelButton;
    private Composite cancelComposite;
    private Composite progressBarComposite;
    private CLabel message;
    private ProgressBar progressBar = null;
    private Shell shell;
    private Display display = null;
    protected volatile boolean isClosed = false;
    protected int executeTime = 50;
    protected String processMessage = "process......";
    protected String shellTitle = "Progress...";
    protected Image processImage = BMotionStudioImage.getImage("icon_loading");
    protected boolean mayCancel = true;
    protected int processBarStyle = 65536;
    protected ProcessThread currentThread;

    public Shell getShell() {
        return this.shell;
    }

    public void setMayCancel(boolean mayCancel) {
        this.mayCancel = mayCancel;
    }

    public void setExecuteTime(int executeTime) {
        this.executeTime = executeTime;
    }

    public void setProcessImage(Image processImage) {
        this.processImage = processImage;
    }

    public void setProcessMessage(String processInfo) {
        this.processMessage = processInfo;
    }

    public ProgressBarDialog(Shell parent) {
        super(parent);
    }

    protected ProcessThread getCurrentThread() {
        return this.currentThread;
    }

    public abstract void initGuage();

    public void open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        this.currentThread = new ProcessThread(this.executeTime);
        this.currentThread.start();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void setClose(boolean b) {
        this.isClosed = b;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 49192);
        this.display = this.shell.getDisplay();
        FormLayout fl = new FormLayout();
        this.shell.setLayout((Layout)fl);
        this.shell.setSize(483, 350);
        this.shell.setText(this.shellTitle);
        this.shell.setBackgroundImage(BMotionStudioImage.getImage("splash"));
        Monitor primary = Display.getCurrent().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        FormData fd = new FormData();
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment(100, -10);
        this.cancelComposite = new Composite((Composite)this.shell, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        this.cancelComposite.setLayout((Layout)gridLayout_1);
        this.cancelComposite.setLayoutData((Object)fd);
        this.cancelComposite.setBackground(Display.getDefault().getSystemColor(1));
        this.cancelButton = new Button(this.cancelComposite, 0);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressBarDialog.this.isClosed = true;
            }
        });
        this.cancelButton.setLayoutData((Object)new GridData(78, -1));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setEnabled(this.mayCancel);
        fd = new FormData();
        fd.right = new FormAttachment(100, -5);
        fd.left = new FormAttachment(0, 10);
        fd.bottom = new FormAttachment((Control)this.cancelComposite, -5);
        this.processMessageLabel = new Label((Composite)this.shell, 0);
        this.processMessageLabel.setBackground(Display.getDefault().getSystemColor(1));
        this.processMessageLabel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, -10);
        fd.left = new FormAttachment(0, 10);
        fd.bottom = new FormAttachment((Control)this.processMessageLabel, -5);
        this.progressBarComposite = new Composite((Composite)this.shell, 0);
        this.progressBarComposite.setLayout((Layout)new FillLayout());
        this.progressBarComposite.setLayoutData((Object)fd);
        this.progressBar = new ProgressBar(this.progressBarComposite, this.processBarStyle);
        this.progressBar.setMaximum(this.executeTime);
        fd = new FormData();
        fd.right = new FormAttachment(100, -5);
        fd.left = new FormAttachment(0, 10);
        fd.bottom = new FormAttachment((Control)this.progressBarComposite, -5);
        this.message = new CLabel((Composite)this.shell, 0);
        this.message.setLayoutData((Object)fd);
        this.message.setImage(this.processImage);
        this.message.setText(this.processMessage);
        this.message.setBackground(Display.getDefault().getSystemColor(1));
    }

    protected abstract String process(int var1);

    protected void cleanUp() {
    }

    protected void doBefore() {
    }

    protected void doAfter() {
    }

    public void setShellTitle(String shellTitle) {
        this.shellTitle = shellTitle;
    }

    public void setProcessBarStyle(boolean pStyle) {
        this.processBarStyle = pStyle ? 65536 : 0;
    }

    class ProcessThread
    extends Thread {
        private int max = 0;
        private volatile boolean shouldStop = false;

        ProcessThread(int max) {
            this.max = max;
        }

        @Override
        public void run() {
            ProgressBarDialog.this.doBefore();
            final int[] i = new int[]{1};
            while (i[0] <= this.max) {
                final String info = ProgressBarDialog.this.process(i[0]);
                if (ProgressBarDialog.this.display.isDisposed()) {
                    return;
                }
                ProgressBarDialog.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (((ProcessThread)ProcessThread.this).ProgressBarDialog.this.progressBar.isDisposed()) {
                            return;
                        }
                        ((ProcessThread)ProcessThread.this).ProgressBarDialog.this.processMessageLabel.setText(info);
                        ((ProcessThread)ProcessThread.this).ProgressBarDialog.this.progressBar.setSelection(i[0]);
                        if (i[0] == ProcessThread.this.max || ((ProcessThread)ProcessThread.this).ProgressBarDialog.this.isClosed) {
                            if (((ProcessThread)ProcessThread.this).ProgressBarDialog.this.isClosed) {
                                ProcessThread.this.shouldStop = true;
                                ProgressBarDialog.this.cleanUp();
                            }
                            ((ProcessThread)ProcessThread.this).ProgressBarDialog.this.shell.close();
                        }
                    }
                });
                if (this.shouldStop) break;
                i[0] = i[0] + 1;
            }
            ProgressBarDialog.this.doAfter();
        }
    }
}

