/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.figure;

import de.bmotionstudio.gef.editor.figure.AbstractBMotionFigure;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class TankFigure
extends AbstractBMotionFigure {
    private Image layerImage;
    private ImageData imageData;
    private int fill_height;
    private double positions;
    private int show_pos;
    private Color fillColor;
    private Boolean showMeasure;

    public TankFigure() {
        PaletteData palette = new PaletteData(new RGB[]{ColorConstants.white.getRGB()});
        this.imageData = new ImageData(1, 1, 8, palette);
        this.imageData.alpha = 255;
        this.imageData.setPixel(0, 0, 0);
        this.layerImage = new Image(null, this.imageData);
    }

    public void setAlpha(int alpha) {
        this.imageData.alpha = alpha;
        if (this.layerImage != null && !this.layerImage.isDisposed()) {
            this.layerImage.dispose();
        }
        this.layerImage = new Image(null, this.imageData);
        this.repaint();
    }

    protected void paintFigure(Graphics g) {
        Rectangle rect = this.getClientArea();
        g.drawImage(this.layerImage, new Rectangle(this.layerImage.getBounds()), rect);
        int fillPos = 0;
        double one_pos = Double.valueOf(rect.height) / this.positions;
        if (this.showMeasure.booleanValue()) {
            g.setForegroundColor(ColorConstants.black);
            g.drawLine(rect.x + 5, rect.y, rect.x + 5, rect.y + rect.height);
            int i = 0;
            while ((double)i <= this.positions) {
                if (i == 0) {
                    g.drawText(String.valueOf((int)(this.positions - (double)i)), rect.x + 18, rect.y + (int)((double)i * one_pos) - 3);
                    g.drawLine(rect.x + 10, rect.y + (int)((double)i * one_pos), rect.x, rect.y + (int)((double)i * one_pos));
                } else if ((double)i == this.positions) {
                    g.drawText(String.valueOf((int)(this.positions - (double)i)), rect.x + 18, rect.y + (int)((double)i * one_pos) - 12);
                    g.drawLine(rect.x + 10, rect.y + (int)((double)i * one_pos) - 1, rect.x, rect.y + (int)((double)i * one_pos) - 1);
                } else {
                    g.drawText(String.valueOf((int)(this.positions - (double)i)), rect.x + 18, rect.y + (int)((double)i * one_pos) - 5);
                    g.drawLine(rect.x + 10, rect.y + (int)((double)i * one_pos), rect.x, rect.y + (int)((double)i * one_pos));
                }
                i += this.show_pos;
            }
            fillPos = 60;
        }
        g.setBackgroundColor(this.fillColor);
        double tmp = one_pos * (this.positions - Double.valueOf(this.fill_height));
        int f_fill_height = (int)tmp;
        g.fillRectangle(rect.x + fillPos, rect.y + f_fill_height, rect.width - fillPos, rect.height);
        super.paintFigure(g);
    }

    public void setFillColor(RGB rgb) {
        if (this.fillColor != null) {
            this.fillColor.dispose();
        }
        this.fillColor = new Color((Device)Display.getDefault(), rgb);
        this.repaint();
    }

    public void setFillHeight(Integer height) {
        this.fill_height = height;
        this.repaint();
    }

    public void setMaxPos(Integer maxPos) {
        this.positions = maxPos.intValue();
        this.repaint();
    }

    public void setInterval(Integer interval) {
        this.show_pos = interval;
        this.repaint();
    }

    public void setMeasure(Boolean bol) {
        this.showMeasure = bol;
        this.repaint();
    }

    public void setBackgroundColor(RGB rgb) {
        this.imageData.palette.colors[0] = rgb;
        if (this.layerImage != null && !this.layerImage.isDisposed()) {
            this.layerImage.dispose();
        }
        this.layerImage = new Image(null, this.imageData);
        this.repaint();
    }

    @Override
    public void deactivateFigure() {
        if (this.fillColor != null) {
            this.fillColor.dispose();
        }
        if (this.layerImage != null) {
            this.layerImage.dispose();
        }
    }
}

