/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.figure;

import de.bmotionstudio.gef.editor.figure.AbstractBMotionFigure;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class LightFigure
extends AbstractBMotionFigure {
    private Color lightColor;

    public LightFigure() {
        this.setOpaque(false);
    }

    @Override
    public void paint(Graphics g) {
        Rectangle r = this.getClientArea();
        g.setBackgroundColor(ColorConstants.lightGray);
        g.fillRectangle(r.x - 5 + r.width / 2, r.y, 11, 14);
        g.setBackgroundColor(this.lightColor);
        g.fillOval(r.x - 5 + r.width / 2, r.y + 1, 11, 11);
        g.setForegroundColor(ColorConstants.black);
        g.drawOval(r.x - 5 + r.width / 2, r.y + 1, 10, 10);
        super.paint(g);
    }

    public void setBackgroundColor(RGB rgb) {
        if (this.lightColor != null) {
            this.lightColor.dispose();
        }
        this.lightColor = new Color((Device)Display.getDefault(), rgb);
        this.repaint();
    }

    @Override
    public void deactivateFigure() {
        if (this.lightColor != null) {
            this.lightColor.dispose();
        }
    }
}

