/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.figure;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class FixedConnectionAnchor
extends AbstractConnectionAnchor {
    public boolean leftToRight = true;
    public int offsetH;
    public int offsetV;
    public boolean topDown = false;

    public FixedConnectionAnchor(IFigure owner) {
        super(owner);
    }

    public void ancestorMoved(IFigure figure) {
        if (figure instanceof ScalableFigure) {
            return;
        }
        super.ancestorMoved(figure);
    }

    public Point getLocation(Point reference) {
        Rectangle r = this.getOwner().getBounds();
        int y = this.topDown ? r.y + this.offsetV : r.bottom() - this.offsetV;
        int x = this.leftToRight ? r.x + this.offsetH : r.right() - this.offsetH;
        PrecisionPoint p = new PrecisionPoint(x, y);
        this.getOwner().translateToAbsolute((Translatable)p);
        return p;
    }

    public Point getReferencePoint() {
        return this.getLocation(null);
    }

    public void setOffsetH(int offsetH) {
        this.offsetH = offsetH;
        this.fireAnchorMoved();
    }

    public void setOffsetV(int offsetV) {
        this.offsetV = offsetV;
        this.fireAnchorMoved();
    }

    public boolean equals(Object o) {
        if (o instanceof FixedConnectionAnchor) {
            FixedConnectionAnchor fa = (FixedConnectionAnchor)((Object)o);
            if (fa.leftToRight == this.leftToRight && fa.topDown == this.topDown && fa.offsetH == this.offsetH && fa.offsetV == this.offsetV && fa.getOwner() == this.getOwner()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return (this.leftToRight ? 31 : 0) + (this.topDown ? 37 : 0) + this.offsetH * 43 + this.offsetV * 47 ^ this.getOwner().hashCode();
    }
}

