/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.figure;

import de.bmotionstudio.gef.editor.figure.AbstractBMotionFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ButtonBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ButtonFigure
extends AbstractBMotionFigure {
    private Label txtLabel;
    private Color backgroundColor;
    private Color foregroundColor;

    public ButtonFigure() {
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.txtLabel = new Label("Click");
        this.add((IFigure)this.txtLabel);
        this.setOpaque(true);
        this.setBorder((Border)new ButtonBorder());
    }

    public void setText(String text) {
        this.txtLabel.setText(text);
    }

    public void setBackgroundColor(RGB rgb) {
        if (this.backgroundColor != null) {
            this.backgroundColor.dispose();
        }
        this.backgroundColor = new Color((Device)Display.getDefault(), rgb);
        this.setBackgroundColor(this.backgroundColor);
    }

    public void setTextColor(RGB rgb) {
        if (this.foregroundColor != null) {
            this.foregroundColor.dispose();
        }
        this.foregroundColor = new Color((Device)Display.getDefault(), rgb);
        this.setForegroundColor(this.foregroundColor);
    }

    public void setBtEnabled(Boolean bool) {
        this.txtLabel.setEnabled(bool.booleanValue());
        this.repaint();
    }

    @Override
    public void deactivateFigure() {
        if (this.backgroundColor != null) {
            this.backgroundColor.dispose();
        }
        if (this.foregroundColor != null) {
            this.foregroundColor.dispose();
        }
    }

    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        if (this.hasFocus()) {
            graphics.setForegroundColor(ColorConstants.black);
            graphics.setBackgroundColor(ColorConstants.white);
            Rectangle area = this.getClientArea();
            graphics.drawFocus(area.x, area.y, area.width, area.height);
        }
    }

    protected void paintClientArea(Graphics graphics) {
        graphics.translate(1, 1);
        graphics.pushState();
        super.paintClientArea(graphics);
        graphics.popState();
        graphics.translate(-1, -1);
    }
}

