/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.eventb;

import de.bmotionstudio.gef.editor.ILanguageService;
import de.bmotionstudio.gef.editor.model.Visualization;
import de.prob.core.Animator;
import de.prob.core.command.LoadEventBModelCommand;
import de.prob.exceptions.ProBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eventb.core.IContextRoot;
import org.eventb.core.IEventBRoot;
import org.eventb.core.IMachineRoot;
import org.rodinp.core.IRodinFile;
import org.rodinp.core.IRodinProject;
import org.rodinp.core.RodinCore;

public class EventBLanguageService
implements ILanguageService {
    private IEventBRoot getCorrespondingFile(IFile file, String machineFileName) {
        IRodinProject rProject = RodinCore.valueOf((IProject)file.getProject());
        IRodinFile rFile = rProject.getRodinFile(machineFileName);
        IEventBRoot eventbRoot = (IEventBRoot)rFile.getRoot();
        return eventbRoot;
    }

    @Override
    public void startProBAnimator(Visualization v) throws ProBException {
        IEventBRoot modelRoot = this.getCorrespondingFile(v.getProjectFile(), v.getMachineName());
        LoadEventBModelCommand.load((Animator)v.getAnimation().getAnimator(), (IEventBRoot)modelRoot);
    }

    @Override
    public boolean isLanguageFile(IFile f) {
        IRodinProject rProject = RodinCore.valueOf((IProject)f.getProject());
        IRodinFile rFile = rProject.getRodinFile(f.getName());
        return rFile != null && (rFile.getRoot() instanceof IMachineRoot || rFile.getRoot() instanceof IContextRoot);
    }
}

